/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.error;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.pageseeder.base.generator.GeneratorErrors;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 8538005834794095150L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlerServlet.class);
    private static volatile String buildNumber = null;

    public void init(ServletConfig config) {
        ErrorHandlerServlet.loadBuildNumber();
    }

    private static synchronized void loadBuildNumber() {
        if (buildNumber == null) {
            buildNumber = Settings.getPageSeederVersion();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) {
        String contentType;
        Throwable error;
        ResponseType type = ErrorHandlerServlet.guessResponseType(request);
        if (!ErrorHandlerServlet.isAPIRequest(request)) {
            try {
                String path = "/ui/error." + (type == ResponseType.XML ? "xml" : "html");
                request.getServletContext().getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (Exception ex) {
                LOGGER.error("Unable to dispatch to user interface error page.", (Throwable)ex);
            }
        }
        if ((error = (Throwable)request.getAttribute("javax.servlet.error.exception")) == null) {
            error = (Throwable)request.getAttribute("com.pageseeder.error.exception");
        }
        if (error != null) {
            LoggerFactory.getLogger(ErrorHandlerServlet.class).error("Error caught by handler", error);
        }
        String content = this.getErrorResponseContent(request, type);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        response.resetBuffer();
        response.setContentLength(bytes.length);
        response.setCharacterEncoding("utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Expires", "0");
        switch (type) {
            case JSON: {
                contentType = "application/json";
                break;
            }
            case HTML: {
                contentType = "text/html";
                break;
            }
            case TEXT: {
                contentType = "text/plain";
                break;
            }
            default: {
                contentType = "application/xml";
            }
        }
        response.setHeader("Content-Type", contentType);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            out.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to write the response", ex);
        }
    }

    private static boolean isAPIRequest(HttpServletRequest req) {
        return ErrorHandlerServlet.isAPIRequest(ErrorHandlerServlet.toRequestPath(req));
    }

    private static boolean isAPIRequest(String path) {
        return path.startsWith("/api/") || path.startsWith("/ui/api/") || path.startsWith("/servlet/") || path.startsWith("/uri/") || path.startsWith("/docid/") || path.startsWith("/publish/") || path.startsWith("/member-resource/") || path.startsWith("/validation-report/") || path.startsWith("/publish-file/") || path.startsWith("/oauth/");
    }

    private static String toRequestPath(HttpServletRequest req) {
        String prefix;
        String path = Objects.toString(ErrorHandlerServlet.getErrorRequestUri(req), req.getRequestURI());
        if (path.startsWith(prefix = GlobalSettings.getSitePrefix())) {
            path = path.substring(prefix.length());
        }
        return path;
    }

    private String getErrorResponseContent(HttpServletRequest req, ResponseType type) {
        ErrorData data = ErrorHandlerServlet.getErrorData(req);
        if (type == ResponseType.JSON) {
            return data.toJson();
        }
        if (type == ResponseType.TEXT) {
            return data.toText();
        }
        if (type == ResponseType.HTML) {
            return data.toHtml();
        }
        return data.toXml();
    }

    private static ResponseType guessResponseType(HttpServletRequest req) {
        String path = ErrorHandlerServlet.toRequestPath(req).toLowerCase();
        if (path.startsWith("/oauth/")) {
            return ResponseType.JSON;
        }
        if (path.endsWith(".json")) {
            return ResponseType.JSON;
        }
        if (path.endsWith(".xml")) {
            return ResponseType.XML;
        }
        if (path.endsWith(".html")) {
            return ResponseType.HTML;
        }
        if (path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".webp")) {
            return ResponseType.TEXT;
        }
        String accept = req.getHeader("Accept");
        if ("application/xml".equals(accept)) {
            return ResponseType.XML;
        }
        if ("application/json".equals(accept)) {
            return ResponseType.JSON;
        }
        return ResponseType.AUTO;
    }

    private static String getErrorRequestUri(HttpServletRequest request) {
        return (String)request.getAttribute("javax.servlet.error.request_uri");
    }

    private static ErrorData getErrorData(HttpServletRequest request) {
        Object status = request.getAttribute("javax.servlet.error.status_code");
        Object id = request.getAttribute("com.pageseeder.error.id");
        int statusCode = status instanceof Integer ? (Integer)status : 200;
        int errorId = id instanceof Integer ? (Integer)id : -1;
        String message = Objects.toString(request.getAttribute("javax.servlet.error.message"), "No information");
        String requestUri = Objects.toString(request.getAttribute("javax.servlet.error.request_uri"), request.getRequestURI());
        return new ErrorData(statusCode, errorId, message, requestUri);
    }

    private static class ErrorData {
        private final int statusCode;
        private final int errorId;
        private final String message;
        private final String datetime;
        private final String requestUri;

        ErrorData(int statusCode, int errorId, String message, String requestUri) {
            this.statusCode = statusCode;
            this.errorId = errorId;
            this.message = message;
            this.datetime = ISO8601.now();
            this.requestUri = requestUri;
        }

        String toJson() {
            StringWriter out = new StringWriter();
            JsonFactory factory = new JsonFactory();
            try (JsonGenerator json = factory.createGenerator((Writer)out);){
                json.writeStartObject();
                if (this.errorId >= 0) {
                    json.writeStringField("id", GeneratorErrors.format((int)this.errorId));
                }
                json.writeNumberField("httpCode", this.statusCode);
                json.writeStringField("request", this.requestUri);
                json.writeStringField("message", this.message);
                json.writeStringField("datetime", this.datetime);
                json.writeStringField("build", buildNumber);
                json.writeEndObject();
                json.flush();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to writing json", (Throwable)ex);
            }
            return out.toString();
        }

        String toXml() {
            XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No, true);
            xml.xmlDecl();
            xml.openElement("error", true);
            if (this.errorId >= 0) {
                xml.attribute("id", GeneratorErrors.format((int)this.errorId));
            }
            xml.element("http-code", Integer.toString(this.statusCode));
            xml.element("request", this.requestUri);
            xml.element("message", this.message);
            xml.element("datetime", this.datetime);
            xml.element("build", buildNumber);
            xml.closeElement();
            return xml.toString();
        }

        String toText() {
            return this.statusCode != 200 ? this.statusCode + " - " + this.message : this.message;
        }

        String toHtml() {
            StringBuilder html = new StringBuilder();
            html.append("<!DOCTYPE html>");
            html.append("<html lang=\"en\">");
            html.append("<head>");
            html.append("  <title>").append(this.message).append("</title>");
            html.append("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
            html.append("</head>");
            html.append("<body>");
            html.append("  <h1>").append(this.message).append("</h1>\n");
            html.append("  <p>Please copy the contents of this page and send it to the system administrator");
            html.append(" of this web site, together with a description of what you where doing including");
            html.append(" anything unusual which may have caused the error.</b></p> <p><b>Thank you.</b></p>\n");
            if (this.errorId >= 0) {
                html.append("  <p><b>Error ID</b>: ").append(GeneratorErrors.format((int)this.errorId)).append("</p>\n");
            }
            html.append("  <p><b>HTTP Code</b>: ").append(this.statusCode).append("</p>\n");
            html.append("  <p><b>Request URI</b>: ").append(RuleUtils.makeXMLSafe((String)this.requestUri)).append("</p>\n");
            html.append("  <p><b>Date</b>: ").append(this.datetime).append("</p>\n");
            html.append("  <p><b>Build</b>: ").append(buildNumber).append("</p>\n");
            html.append("</body>\n");
            html.append("</html>\n");
            return html.toString();
        }
    }

    private static enum ResponseType {
        JSON,
        XML,
        HTML,
        TEXT,
        AUTO;

    }
}

