/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.developer.config.Bundle;
import com.pageseeder.developer.config.BundleBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.pageseeder.xmlwriter.XMLWriter;

public final class URLConfigBundle
extends BundleBase
implements Bundle {
    private static final Pattern VALID_TYPE = Pattern.compile("[a-zA-Z0-9_]+");
    private static final UniversalPrinter.FileFields ROLES = new UniversalPrinter.FileFields(){

        public void print(OutputPrinter out, File f, String location) {
            String name = f.getName();
            String role = null;
            if ("url-template.psml".equals(name)) {
                role = "URL Template";
            } else if ("url-config.xml".equals(name)) {
                role = "URL Config";
            } else if ("editor-config.xml".equals(name)) {
                role = "Editor Config";
            } else if (name.endsWith(".sch")) {
                role = "Schematron";
            }
            if (role != null) {
                out.field("role", role);
            }
            boolean isDefaultTemplate = location.startsWith(TemplateFiles.Zone.TEMPLATE.folder(Template.DEFAULT));
            boolean isDefaultWeb = location.startsWith(TemplateFiles.Zone.WEB.folder(Template.DEFAULT));
            out.field("editable", Boolean.toString(!isDefaultTemplate && !isDefaultWeb));
            if (isDefaultTemplate || isDefaultWeb) {
                out.field("definedby", "default");
            } else if (location.startsWith(TemplateFiles.Zone.TEMPLATE.folder())) {
                out.field("definedby", location.substring(TemplateFiles.Zone.TEMPLATE.folder().length() + 1).split("/")[0]);
            }
        }
    };

    public URLConfigBundle(String name) {
        super(name);
    }

    @Override
    public void load(Template template, File webapp) {
        TemplateFiles resources = new TemplateFiles(template, webapp);
        File dir = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/" + this.name() + "/");
        File t = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/" + this.name() + "/url-template.psml");
        File c = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/" + this.name() + "/url-config.xml");
        File e = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/" + this.name() + "/editor-config.xml");
        File[] schemas = dir.listFiles((dir1, name) -> name.endsWith(".sch") && !name.equals("default.sch"));
        this.add(t);
        this.add(c);
        this.add(e);
        if (schemas != null) {
            for (File v : schemas) {
                this.add(v);
            }
        }
        File v = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/" + this.name() + "/default.sch");
        this.add(v);
    }

    public void toXML(XMLWriter xml) {
        UniversalPrinter out = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml));
        out.startObject("bundle");
        out.field("name", this.name());
        out.field("type", "url");
        for (File f : this.files()) {
            out.writeFile(f, 0, false, ROLES);
        }
        out.endObject();
    }

    public static List<String> list(Template template, File webapp) {
        TemplateFiles resources = new TemplateFiles(template, webapp);
        ArrayList<String> names = new ArrayList<String>();
        File documents = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/url/");
        File[] ff = documents.listFiles();
        if (documents.exists() && ff != null) {
            for (File f : ff) {
                String name = f.getName();
                if (!f.isDirectory() || f.isHidden() || !VALID_TYPE.matcher(name).matches()) continue;
                names.add(name);
            }
        }
        return names;
    }
}

