/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.config.Bundle;
import com.pageseeder.developer.config.Bundles;
import java.io.File;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
public final class GetBundle
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String location = req.getParameter((Parameter)StandardParameters.location);
        if (location != null) {
            Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
            if (kit == null) {
                return new ForbiddenCheck();
            }
            String owner = GroupRule.getTemplate((Group)group);
            if (!kit.isDefault() && !kit.name().equals(owner)) {
                return new ForbiddenCheck();
            }
        }
        return new ConfigureProjectCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String template;
        Group group = req.getGroup();
        XMLWriter xml = res.getXMLWriter();
        boolean def = "true".equals(req.getParameter((Parameter)StandardParameters.default_));
        String string = template = def ? "default" : GroupRule.getTemplate((Group)group);
        if (template != null) {
            Template kit = new Template(template);
            Bundle bundle = null;
            String type = req.getParameter((Parameter)StandardParameters.type);
            String name = req.getParameter((Parameter)StandardParameters.name);
            if (type != null && name != null) {
                bundle = Bundles.getInstance(type, name);
            } else {
                String location = req.getParameter((Parameter)StandardParameters.location);
                bundle = Bundles.forLocation(location);
            }
            if (bundle != null) {
                File webapp = new File(Settings.getContextPath());
                bundle.load(kit, webapp);
                bundle.toXML(xml);
            } else {
                xml.emptyElement("no-bundle");
            }
            xml.flush();
        }
    }
}

