/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.developer.config.Bundle;
import com.pageseeder.developer.config.BundleBase;
import com.pageseeder.developer.config.PSMLDocConfigBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.xmlwriter.XMLWriter;

public final class DocConfigBundle
extends BundleBase
implements Bundle {
    private static final Pattern VALID_TYPE = Pattern.compile("[a-z]+");
    private static final UniversalPrinter.FileFields ROLES = new UniversalPrinter.FileFields(){

        public void print(OutputPrinter out, File f, String location) {
            String name = f.getName();
            String role = null;
            if ("media-template.psml".equals(name)) {
                role = "Media Template";
            }
            if ("document-template.psml".equals(name)) {
                role = "Document Template";
            } else if ("editor-config.xml".equals(name)) {
                role = "Editor Config";
            } else if (name.endsWith(".css")) {
                role = "Style";
            } else if (name.endsWith(".sch")) {
                role = "Schematron";
            }
            if (role != null) {
                out.field("role", role);
            }
            boolean isDefaultTemplate = location.startsWith(TemplateFiles.Zone.TEMPLATE.folder(Template.DEFAULT));
            boolean isDefaultWeb = location.startsWith(TemplateFiles.Zone.WEB.folder(Template.DEFAULT));
            out.field("editable", Boolean.toString(!isDefaultTemplate && !isDefaultWeb));
            if (isDefaultTemplate || isDefaultWeb) {
                out.field("definedby", "default");
            } else if (location.startsWith(TemplateFiles.Zone.TEMPLATE.folder())) {
                out.field("definedby", location.substring(TemplateFiles.Zone.TEMPLATE.folder().length() + 1).split("/")[0]);
            }
        }
    };

    public DocConfigBundle(String name) {
        super(name);
    }

    @Override
    public void load(Template template, File webapp) {
        File old;
        TemplateFiles resources = new TemplateFiles(template, webapp);
        File dir = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/" + this.name() + "/");
        File t = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/" + this.name() + "/media-template.psml");
        if (!t.exists() && (old = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/" + this.name() + "/document-template.psml")).exists()) {
            t = old;
        }
        File e = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/" + this.name() + "/editor-config.xml");
        File[] schemas = dir.listFiles((dir1, name) -> name.endsWith(".sch") && !name.equals("default.sch"));
        if (!"psml".equals(this.name())) {
            this.add(t);
            this.add(e);
        }
        if (schemas != null) {
            for (File v : schemas) {
                this.add(v);
            }
        }
        this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/" + this.name() + "/default.sch"));
        if ("docx".equals(this.name())) {
            this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/docx/word-import-config.xml"));
            this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/docx/psml-split-config.xml"));
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("bundle");
        xml.attribute("name", this.name());
        xml.attribute("type", "document");
        for (File f : this.files()) {
            UniversalPrinter p = UniversalPrinter.newWriter((OutputType)OutputType.XML);
            try {
                p.writeFile(f, 0, false, ROLES);
                xml.writeXML(p.toString());
            }
            finally {
                if (p == null) continue;
                p.close();
            }
        }
        xml.closeElement();
    }

    public static PSMLDocConfigBundle forLocation(String location) {
        Template kit = TemplateFactory.forLocation((String)location);
        if (kit == null) {
            return null;
        }
        String prefix = TemplateFiles.Zone.TEMPLATE.folder(kit);
        if (location.startsWith(prefix)) {
            return DocConfigBundle.forTemplateLocation(location.substring(prefix.length()));
        }
        return null;
    }

    public static List<String> list(Template template, File webapp) {
        TemplateFiles resources = new TemplateFiles(template, webapp);
        ArrayList<String> names = new ArrayList<String>();
        File documents = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/document/");
        File[] ff = documents.listFiles();
        if (documents.exists() && ff != null) {
            for (File f : ff) {
                String name = f.getName();
                if (!f.isDirectory() || f.isHidden() || !VALID_TYPE.matcher(name).matches()) continue;
                names.add(name);
            }
        }
        return names;
    }

    private static PSMLDocConfigBundle forTemplateLocation(String location) {
        Pattern pattern = Pattern.compile("/document/([a-zA-Z0-9_]+)/.*");
        Matcher m = pattern.matcher(location);
        if (m.matches()) {
            return new PSMLDocConfigBundle(m.group(1));
        }
        return null;
    }
}

