/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.xml.FatalErrorHandler;
import com.pageseeder.load.edits.ContentPart;
import com.pageseeder.load.edits.Fragment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLMetadataHandler
extends DefaultHandler {
    private static final String XML_WRITING_FAILED = "Failed to write XML output: ";
    private static final String METADATA_FRAGMENT = "default";
    private static SAXParserFactory factory;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private Fragment medataFragment = null;
    private final StringBuilder tempCharacters = new StringBuilder();
    private XMLWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
    private Map<String, String> existingProperties = Collections.emptyMap();
    private final Map<String, String> loadedProperties = new HashMap<String, String>();
    private XMLWriter comparisonXml = new XMLStringWriter(XML.NamespaceAware.No);
    private XMLWriter propertyPSML = null;
    private String currentPropertyName = null;
    private boolean ignore = false;

    public void setExistingProperties(Map<String, String> existingProperties) {
        this.existingProperties = existingProperties == null ? Collections.emptyMap() : existingProperties;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if ("metadata".equals(localName)) {
            this.medataFragment = new Fragment(METADATA_FRAGMENT, "application/vnd.pageseeder.psml+xml");
            this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            this.comparisonXml = new XMLStringWriter(XML.NamespaceAware.No);
        } else if (this.medataFragment != null) {
            if ("property".equals(localName)) {
                String pname = atts.getValue("name");
                if (this.existingProperties.containsKey(pname)) {
                    try {
                        String propPSML = this.existingProperties.get(pname);
                        this.xml.writeXML(propPSML);
                        this.comparisonXml.writeXML(propPSML);
                        this.loadedProperties.put(pname, propPSML);
                        this.ignore = true;
                    }
                    catch (IOException ioe) {
                        this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
                    }
                } else {
                    this.currentPropertyName = pname;
                    this.propertyPSML = new XMLStringWriter(XML.NamespaceAware.No);
                }
            }
            if (!this.ignore) {
                try {
                    XMLWriter psml = this.propertyPSML == null ? this.xml : this.propertyPSML;
                    psml.openElement(localName, true);
                    this.writeTempCharacters();
                    this.comparisonXml.openElement(localName, true);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String name = atts.getLocalName(i);
                        String value = atts.getValue(i);
                        psml.attribute(name, value);
                        this.comparisonXml.attribute(name, value);
                    }
                }
                catch (IOException ioe) {
                    this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if ("metadata".equals(localName) && this.medataFragment != null) {
            ContentPart content = null;
            try {
                this.xml.close();
                this.comparisonXml.close();
                content = new ContentPart(this.xml.toString(), this.comparisonXml.toString());
            }
            catch (IOException ioe) {
                this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
            }
            if (content != null && !Strings.isEmpty((String)content.toString())) {
                this.medataFragment.addContents(Collections.singletonList(content));
            }
        } else if (this.medataFragment != null) {
            XMLWriter psml = this.propertyPSML == null ? this.xml : this.propertyPSML;
            try {
                if (!this.ignore) {
                    psml.closeElement();
                    this.writeTempCharacters();
                    this.comparisonXml.closeElement();
                }
                if ("property".equals(localName)) {
                    if (this.currentPropertyName != null && this.propertyPSML != null) {
                        String propPSML = this.propertyPSML.toString();
                        this.loadedProperties.put(this.currentPropertyName, propPSML);
                        this.xml.writeXML(propPSML);
                    }
                    this.propertyPSML = null;
                    this.currentPropertyName = null;
                    this.ignore = false;
                }
            }
            catch (IOException ioe) {
                this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
            }
        }
        this.tempCharacters.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.medataFragment != null) {
            try {
                String s = new String(ch, start, length);
                this.tempCharacters.append(s);
                XMLWriter psml = this.propertyPSML == null ? this.xml : this.propertyPSML;
                psml.writeText(s);
            }
            catch (IOException ioe) {
                this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
            }
        }
    }

    private void writeTempCharacters() throws IOException {
        String s = this.tempCharacters.toString();
        if (s.trim().length() > 0) {
            this.comparisonXml.writeText(s);
        }
        this.tempCharacters.setLength(0);
    }

    public Map<String, String> getProperties() {
        return this.loadedProperties;
    }

    public Fragment getFragment() {
        return this.medataFragment;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream xmlContents) throws SAXException, IOException {
        XMLReader reader;
        try {
            if (factory == null) {
                PSMLMetadataHandler.initFactory();
            }
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Failed to create an XML Reader", ex);
        }
        reader.setContentHandler(this);
        reader.setErrorHandler((ErrorHandler)new FatalErrorHandler());
        try {
            reader.parse(new InputSource(xmlContents));
        }
        finally {
            xmlContents.close();
        }
    }

    private static void initFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory f = XMLHelpers.safeSAXParserFactory();
        f.setValidating(false);
        f.setNamespaceAware(true);
        factory = f;
    }
}

