/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.developer.DevUtils;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true)
public final class GetDefaultFiles
implements Generator,
SingleCheck {
    private volatile File webapp = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        if (this.webapp == null) {
            this.webapp = new File(Settings.getContextPath());
        }
        XMLWriter xml = res.getXMLWriter();
        String location = req.getParameter((Parameter)StandardParameters.location);
        this.toXML(xml, location);
        xml.flush();
    }

    private void toXML(XMLWriter xml, String location) throws IOException {
        TemplateFiles resources = new TemplateFiles(Template.DEFAULT);
        for (TemplateFiles.Zone zone : EnumSet.of(TemplateFiles.Zone.TEMPLATE, TemplateFiles.Zone.WEB)) {
            File root = new File(this.webapp, zone.folder(Template.DEFAULT));
            if (location != null) {
                root = new File(root, location);
            }
            this.toXML(root, xml, resources, zone);
        }
    }

    private void toXML(File f, XMLWriter xml, TemplateFiles resources, TemplateFiles.Zone zone) throws IOException {
        String location = "/" + Files.path((File)this.webapp, (File)f);
        xml.openElement("file");
        xml.attribute("name", f.getName());
        xml.attribute("path", location);
        if (f.exists()) {
            if (f.isDirectory()) {
                xml.attribute("type", "folder");
                for (File x : f.listFiles(DevUtils.READABLE_AND_VISIBLE)) {
                    if (!this.filter(location, x, zone)) continue;
                    this.toXML(x, xml, resources, zone);
                }
            } else {
                String type = Medias.getMediaType((File)f);
                boolean isText = Medias.isText((String)type);
                xml.attribute("type", "file");
                if (type != null) {
                    xml.attribute("mediatype", type);
                }
                xml.attribute("length", Long.toString(f.length()));
                xml.attribute("modified", ISO8601.DATETIME.format(f.lastModified()));
                xml.attribute("text", Boolean.toString(isText));
            }
        } else {
            xml.attribute("status", "not-found");
        }
        xml.closeElement();
    }

    private boolean filter(String location, File f, TemplateFiles.Zone zone) {
        if (TemplateFiles.Zone.WEB == zone) {
            return this.filterWeb(location, f);
        }
        if (TemplateFiles.Zone.TEMPLATE == zone) {
            return this.filterTemplate(location, f);
        }
        return false;
    }

    private boolean filterWeb(String location, File f) {
        String name = f.getName();
        if ("/weborganic".equals(location)) {
            return "email".equals(name) || "document".equals(name);
        }
        if (f.isFile()) {
            return true;
        }
        if (location.startsWith("/weborganic/document")) {
            return true;
        }
        return location.startsWith("/weborganic/email");
    }

    private boolean filterTemplate(String location, File f) {
        if (f.isFile()) {
            return true;
        }
        String name = f.getName();
        if (location.startsWith("/WEB-INF/template/default/")) {
            return true;
        }
        if ("/WEB-INF/template/default".equals(location)) {
            if ("batch".equals(name)) {
                return true;
            }
            if ("document".equals(name)) {
                return true;
            }
            if ("folder".equals(name)) {
                return true;
            }
            if ("group".equals(name)) {
                return true;
            }
            if ("index".equals(name)) {
                return true;
            }
            if ("newgroup".equals(name)) {
                return true;
            }
            if ("notification".equals(name)) {
                return true;
            }
            if ("publish".equals(name)) {
                return true;
            }
            if ("publication".equals(name)) {
                return true;
            }
            if ("psml".equals(name)) {
                return true;
            }
            if ("url".equals(name)) {
                return true;
            }
        }
        return false;
    }
}

