/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Locations;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.IOException;

@Requires(database=true, parameters={"location"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDefaultFile
implements Generator,
SingleCheck {
    private volatile File webapp = null;
    private static final UniversalPrinter.FileFields EDITABLE = new UniversalPrinter.FileFields(){

        public void print(OutputPrinter out, File f, String location) {
            out.field("editable", false);
        }
    };

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
        if (kit == null) {
            return new ForbiddenCheck();
        }
        if (!kit.isDefault()) {
            return new ForbiddenCheck();
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        if (this.webapp == null) {
            this.webapp = new File(Settings.getContextPath());
        }
        String location = req.getParameter((Parameter)StandardParameters.location);
        File file = Locations.toFile((File)this.webapp, (String)location);
        UniversalPrinter out = res.getUniversalWriter();
        out.writeFile(file, 1, file.isFile(), EDITABLE);
        out.flush();
    }
}

