/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplatePacker;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.developer.DeveloperZone;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

@Requires(database=true, group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ExportProjectFiles
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String template = GroupRule.getTemplate((Group)group);
        Template kit = new Template(template);
        if (kit.isDefault()) {
            return new ForbiddenCheck();
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        String template = GroupRule.getTemplate((Group)group);
        Template kit = new Template(template);
        File webapp = new File(Settings.getContextPath());
        File export = new File(webapp, DeveloperZone.EXPORT.folder(kit));
        if (!export.exists()) {
            FileUtils.forceMkdir((File)export);
        }
        File pack = new File(export, "ps-" + kit.name() + "-" + ISO8601.today() + ".zip");
        TemplatePacker packer = new TemplatePacker(webapp);
        Member self = req.getAuthenticatedMember();
        packer.pack(kit, pack, self.getUsername());
        res.setStatus(GeneratorStatus.CREATED);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("export");
        out.field("project", template);
        out.field("datetime", ISO8601.now());
        out.field("file", pack.getName());
        out.endObject();
        out.flush();
    }
}

