/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewXLinkCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.util.Collection;

@Requires(parameters={"id"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetComment
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Object check = new NoCheck();
        XLink xl = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L));
        if (xl != null) {
            check = "all".equals(req.getParameter((Parameter)StandardParameters.emails)) ? new EditXLinkCheck(URIRule.getURIByXLink((XLink)xl), xl) : new ViewXLinkCheck(xl);
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        boolean includeGroups;
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        String emails = req.getParameter((Parameter)StandardParameters.emails, "none");
        Database db = req.getDatabase();
        XLink xl = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L));
        if (!XLinks.isComment((XLink)xl)) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.COMMENT_NOT_FOUND, "No comment found with ID " + req.getParameter((Parameter)StandardParameters.id, -1L));
            return;
        }
        Collection<Group> groups = Comments.getReturnGroups(req);
        UserDetails userdetails = null;
        boolean bl = includeGroups = !"none".equals(returngroups);
        if (includeGroups) {
            userdetails = req.getMember() != null ? new UserDetailsManager().get(db, req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeComment(xl, db, null, groups, true, true, true, "all".equals(emails), null, userdetails, null);
        out.flush();
    }
}

