/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.cache;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import java.io.IOException;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetCachingOverview
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        List managers = CacheManager.ALL_CACHE_MANAGERS;
        if (managers.size() > 1) {
            out.startCollection("cache-managers", OutputPrinter.CollectionOption.JSON_ONLY);
        }
        for (CacheManager manager : managers) {
            out.startObject("cache-manager");
            out.field("name", manager.getName());
            String[] names = manager.getCacheNames();
            out.startCollection("caches", OutputPrinter.CollectionOption.JSON_ONLY);
            for (String name : names) {
                Ehcache cache = manager.getEhcache(name);
                GetCachingOverview.print(cache, (OutputPrinter)out);
            }
            out.endCollection();
            out.endObject();
        }
        if (managers.size() > 1) {
            out.endCollection();
        }
        out.flush();
    }

    private static void print(Ehcache cache, OutputPrinter out) {
        if (cache == null) {
            return;
        }
        Status status = cache.getStatus();
        out.startObject("cache");
        out.field("name", cache.getName());
        out.field("guid", cache.getGuid());
        out.field("status", status.toString());
        out.field("disabled", cache.isDisabled());
        if (status == Status.STATUS_ALIVE) {
            out.startObject("info");
            out.field("size", (long)cache.getSize());
            out.endObject();
        }
        out.endObject();
    }
}

