/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.ai.core.IntelligenceConfigException;
import com.pageseeder.common.properties.GlobalSettings;
import net.pageseeder.aws.LiteAwsConfig;

public final class Bedrock {
    private Bedrock() {
    }

    public static LiteAwsConfig getAwsConfig() throws IntelligenceConfigException {
        String awsRegion = GlobalSettings.getString((String)"awsRegion", (String)"");
        String awsAccessKeyId = GlobalSettings.getString((String)"awsAccessKeyId", (String)"");
        String awsSecretAccessKey = GlobalSettings.getString((String)"awsSecretAccessKey", (String)"");
        String awsAccountId = GlobalSettings.getString((String)"awsAccountId", (String)"");
        if (awsRegion.isEmpty()) {
            throw new IntelligenceConfigException("Missing AWS region");
        }
        if (awsAccessKeyId.isEmpty()) {
            throw new IntelligenceConfigException("Missing AWS access key ID");
        }
        if (awsSecretAccessKey.isEmpty()) {
            throw new IntelligenceConfigException("Missing AWS secret access key");
        }
        if (awsAccountId.isEmpty()) {
            throw new IntelligenceConfigException("Missing AWS account ID");
        }
        return LiteAwsConfig.forRegion((String)awsRegion).withCredentials(awsAccessKeyId, awsSecretAccessKey).withAccountId(awsAccountId);
    }
}

