/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.ai.core.RedactionEngine;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.PSML;
import org.pageseeder.psml.md.MarkdownOutputOptions;
import org.pageseeder.psml.md.MarkdownSerializer;
import org.pageseeder.psml.model.PSMLElement;

public final class AttachmentManager {
    private static final MarkdownOutputOptions OUTPUT_OPTIONS = MarkdownOutputOptions.defaultOptions().metadata(false).captions(true).image(MarkdownOutputOptions.ImageFormat.NONE).superSub(MarkdownOutputOptions.SuperSubFormat.UNICODE).xref(MarkdownOutputOptions.XrefFormat.BOLD_TEXT);
    private static final List<String> SUPPORTED = List.of("text/plain", "text/html", "application/xml", "application/vnd.pageseeder.psml+xml", "image/png", "image/jpeg", "image/gif", "image/webp");
    private final Database db;
    private final Group group;
    private final Member member;
    private @Nullable RedactionEngine redactionEngine = null;

    public AttachmentManager(Database db, Group group, Member member) {
        this.db = db;
        this.group = group;
        this.member = member;
    }

    public @Nullable RedactionEngine getRedactionEngine() {
        return this.redactionEngine;
    }

    public void setRedactionEngine(@Nullable RedactionEngine redactionEngine) {
        this.redactionEngine = redactionEngine;
    }

    public static boolean isSupportedType(URI uri) {
        String mediatype = uri.getType();
        return SUPPORTED.contains(mediatype);
    }

    public static List<String> listSupported() {
        return SUPPORTED;
    }

    public String asDataURI(URI uri) throws URIException, IOException {
        String mediaType;
        switch (mediaType = uri.getType()) {
            case "application/vnd.pageseeder.psml+xml": {
                return this.encodePSMLAsDataURI(uri);
            }
            case "application/pdf": 
            case "image/png": 
            case "image/jpeg": 
            case "image/gif": {
                return this.encodeBinaryAsDataURI(uri);
            }
            case "text/plain": 
            case "text/html": 
            case "application/xml": {
                return this.encodeTextAsDataURI(uri);
            }
        }
        throw new IllegalArgumentException("Unsupported media type: " + mediaType);
    }

    public String encodeTextAsDataURI(URI uri) throws URIException, IOException {
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), this.group.getName());
        resolver.setPSMLFormat(false);
        try (InputStream inputStream = resolver.getContent(this.db);){
            String text = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            String redacted = this.redactionEngine != null ? this.redactionEngine.redact(text) : text;
            String string = "data:text/plain," + URLEncoder.encode(redacted, StandardCharsets.UTF_8);
            return string;
        }
    }

    public String encodePSMLAsDataURI(URI uri) throws URIException, IOException {
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), this.group.getName());
        resolver.setPSMLFormat(true);
        resolver.setPublication(Publications.blank((URI)uri, (Group)this.group), 1, true);
        UserDetails userdetails = new UserDetailsManager().get(this.db, this.member.getId(), false);
        resolver.setTransclude(userdetails);
        try (InputStream inputStream = resolver.getContent(this.db);){
            PSMLElement psml = PSML.load((Reader)new InputStreamReader(inputStream));
            MarkdownSerializer serializer = new MarkdownSerializer();
            serializer.setOptions(OUTPUT_OPTIONS);
            StringWriter markdown = new StringWriter();
            serializer.serialize(psml, (Appendable)markdown);
            String redacted = this.redactionEngine != null ? this.redactionEngine.redact(markdown.toString()) : markdown.toString();
            String string = "data:text/plain," + URLEncoder.encode(redacted, StandardCharsets.UTF_8);
            return string;
        }
    }

    public String encodeBinaryAsDataURI(URI uri) throws URIException, IOException {
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), this.group.getName());
        resolver.setPSMLFormat(false);
        try (InputStream inputStream = resolver.getContent(this.db);){
            String base64 = AttachmentManager.encodeInputStreamToBase64(inputStream);
            String string = "data:" + uri.getType() + ";base64," + base64;
            return string;
        }
    }

    public static String encodeInputStreamToBase64(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (OutputStream outputStream = Base64.getEncoder().wrap(byteArrayOutputStream);){
                inputStream.transferTo(outputStream);
            }
            String string = byteArrayOutputStream.toString(StandardCharsets.ISO_8859_1);
            return string;
        }
    }
}

