/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.anthropic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pageseeder.ai.core.Bedrock;
import com.pageseeder.ai.core.IntelligenceException;
import com.pageseeder.ai.core.IntelligenceProviderClient;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.pageseeder.ai.anthropic.ClaudeContent;
import net.pageseeder.ai.anthropic.ClaudeMessage;
import net.pageseeder.ai.anthropic.ClaudeModel;
import net.pageseeder.ai.anthropic.ClaudeRequest;
import net.pageseeder.ai.anthropic.model.ErrorResponse;
import net.pageseeder.ai.anthropic.model.MessageResponse;
import net.pageseeder.ai.anthropic.model.Response;
import net.pageseeder.ai.anthropic.model.SuccessfulResponse;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.aws.AwsService;
import net.pageseeder.aws.AwsServices;
import net.pageseeder.aws.LiteAwsClient;
import net.pageseeder.aws.LiteAwsConfig;
import net.pageseeder.aws.LiteAwsRequest;
import net.pageseeder.aws.LiteAwsResponse;
import net.pageseeder.aws.Payload;
import net.pageseeder.aws.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BedrockApiClient
implements IntelligenceProviderClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BedrockApiClient.class);
    public static final String ANTHROPIC_VERSION = "bedrock-2023-05-31";

    @Override
    public Response<MessageResponse> askModel(PromptTemplate template, Member member, Map<String, String> parameters) throws IntelligenceException {
        Response<MessageResponse> response;
        LiteAwsConfig awsConfig = Bedrock.getAwsConfig();
        try {
            response = this.askClaudeViaBedrock(template, member, parameters, awsConfig);
        }
        catch (IOException ex) {
            throw new IntelligenceException("Unable to communicate with AWS Bedrock", ex);
        }
        catch (Exception ex) {
            throw new IntelligenceException("Unknown error from AWS Bedrock", ex);
        }
        return response;
    }

    public Response<MessageResponse> askClaudeViaBedrock(PromptTemplate template, Member member, Map<String, String> parameters, LiteAwsConfig awsConfig) throws IOException {
        Prompt prompt = template.toPrompt(parameters);
        ClaudeModel model = ClaudeModel.CLAUDE_3_7_SONNET_20250219;
        ClaudeRequest r = new ClaudeRequest();
        r.setMaxTokens(prompt.getMaxTokens());
        r.setModel(model);
        r.setTemperature(prompt.getTemperature());
        if (!prompt.getSystem().isEmpty()) {
            r.setSystem(prompt.getSystem());
        }
        for (Content content : prompt.getUser()) {
            if (content.isText()) {
                r.addUserMessage(content.getText());
                continue;
            }
            r.addUserMessage(content.getBytes(), content.mediaType());
        }
        AwsService bedrockRuntime = AwsServices.newBedrockRuntime((String)awsConfig.region());
        String inferenceProfileName = "apac." + model.getBedrock();
        String inferenceProfileArn = "arn:aws:bedrock:" + awsConfig.region() + ":" + awsConfig.accountId() + ":inference-profile/" + inferenceProfileName;
        String jsonBody = BedrockApiClient.toJson(r);
        Payload payload = new Payload("application/json", jsonBody);
        LiteAwsRequest req = LiteAwsRequest.newPostRequest((AwsService)bedrockRuntime, (String)("/model/" + Utils.uriEncode((String)inferenceProfileArn, (boolean)false) + "/invoke"), (Payload)payload).withHeader("Accept", "application/json").withHeader("Content-Length", String.valueOf(payload.bytes().length));
        LiteAwsClient client = new LiteAwsClient(awsConfig);
        LiteAwsResponse response = client.fetch(req);
        int statusCode = response.statusCode();
        String responseBody = response.bodyAsString();
        ObjectMapper mapper = new ObjectMapper();
        if (statusCode == 200) {
            return new Response(statusCode, (SuccessfulResponse)((MessageResponse)mapper.readValue(responseBody, MessageResponse.class)));
        }
        LOGGER.error("Bedrock returned an error: {} - {}", (Object)statusCode, (Object)responseBody);
        return Response.error((int)statusCode, (ErrorResponse)((ErrorResponse)mapper.readValue(responseBody, ErrorResponse.class)));
    }

    public static String toJson(ClaudeRequest request) {
        JsonFactory factory = new JsonFactory();
        StringWriter out = new StringWriter();
        try {
            JsonGenerator json = factory.createGenerator((Writer)out);
            json.writeStartObject();
            json.writeStringField("anthropic_version", ANTHROPIC_VERSION);
            json.writeNumberField("max_tokens", request.getMaxTokens());
            if (request.getSystem() != null) {
                json.writeStringField("system", request.getSystem());
            }
            if (request.getTemperature() > 0.0) {
                json.writeNumberField("temperature", request.getTemperature());
            }
            json.writeArrayFieldStart("messages");
            BedrockApiClient.writeMessages(json, request.getUserMessages());
            json.writeEndArray();
            json.writeEndObject();
            json.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to convert ClaudeRequest to JSON", ex);
        }
        return out.toString();
    }

    private static void writeMessages(JsonGenerator json, List<ClaudeMessage> messages) throws IOException {
        for (ClaudeMessage m : messages) {
            json.writeStartObject();
            json.writeStringField("role", m.getRoleAsString());
            List contents = m.getContents();
            if (contents.size() == 1 && ((ClaudeContent)contents.get(0)).getType() == ClaudeContent.Type.TEXT) {
                json.writeStringField("content", ((ClaudeContent)contents.get(0)).getText());
            } else {
                json.writeArrayFieldStart("content");
                for (ClaudeContent c : contents) {
                    json.writeStartObject();
                    json.writeStringField("type", c.getTypeAsString());
                    if (c.getType() == ClaudeContent.Type.TEXT) {
                        json.writeStringField("text", c.getText());
                    } else if (c.getType() == ClaudeContent.Type.IMAGE || c.getType() == ClaudeContent.Type.DOCUMENT) {
                        json.writeObjectFieldStart("source");
                        json.writeStringField("type", "base64");
                        json.writeStringField("media_type", c.getMediaType());
                        json.writeStringField("data", c.getBytesAsBase64());
                        json.writeEndObject();
                    }
                    json.writeEndObject();
                }
                json.writeEndArray();
            }
            json.writeEndObject();
        }
    }
}

