/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.anthropic;

import com.pageseeder.ai.core.IntelligenceConfigException;
import com.pageseeder.ai.core.IntelligenceException;
import com.pageseeder.ai.core.IntelligenceProviderClient;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.Member;
import java.util.Map;
import net.pageseeder.ai.anthropic.AnthropicApi;
import net.pageseeder.ai.anthropic.ClaudeException;
import net.pageseeder.ai.anthropic.ClaudeModel;
import net.pageseeder.ai.anthropic.ClaudeRequest;
import net.pageseeder.ai.anthropic.model.MessageResponse;
import net.pageseeder.ai.anthropic.model.Response;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptTemplate;

public final class AnthropicApiClient
implements IntelligenceProviderClient {
    @Override
    public Response<MessageResponse> askModel(PromptTemplate template, Member member, Map<String, String> parameters) throws IntelligenceException {
        Response<MessageResponse> response;
        String apiKey = GlobalSettings.getString((String)"anthropicApiKey", (String)"");
        if (apiKey.isEmpty()) {
            throw new IntelligenceConfigException("Missing Anthropic API key");
        }
        try {
            response = this.askClaude(template, member, parameters, apiKey);
        }
        catch (ClaudeException ex) {
            throw new IntelligenceException("Unable to communicate with Anthropic API", ex);
        }
        return response;
    }

    private Response<MessageResponse> askClaude(PromptTemplate template, Member member, Map<String, String> parameters, String apiKey) throws ClaudeException {
        Prompt prompt = template.toPrompt(parameters);
        ClaudeRequest r = new ClaudeRequest();
        r.setUserId(member.getId().toString());
        r.setMaxTokens(prompt.getMaxTokens());
        r.setModel(ClaudeModel.CLAUDE_3_7_SONNET_20250219);
        r.setTemperature(prompt.getTemperature());
        if (!prompt.getSystem().isEmpty()) {
            r.setSystem(prompt.getSystem());
        }
        for (Content content : prompt.getUser()) {
            if (content.isText()) {
                r.addUserMessage(content.getText());
                continue;
            }
            r.addUserMessage(content.getBytes(), content.mediaType());
        }
        AnthropicApi api = new AnthropicApi(apiKey);
        return api.postMessage(r);
    }
}

