/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai;

import com.pageseeder.ai.core.Prompts;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.List;
import net.pageseeder.ai.prompt.PromptTemplate;

@Requires(uri=true, group=true, member=true)
public final class ListPromptTemplates
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        assert (uri != null);
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        List<PromptTemplate> prompts = Prompts.listPromptTemplates(uri, group);
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("prompt-templates");
        for (PromptTemplate prompt : prompts) {
            Prompts.printPromptTemplate((OutputPrinter)out, prompt);
        }
        out.endCollection();
        out.flush();
    }
}

