/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.publish.Publisher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import net.pageseeder.xmltools.usage.UsageReportBuilder;

public final class URIUsageSchema
implements Action<URI> {
    private static final File TEMPLATE_FOLDER = new File(Settings.getContextPath(), "WEB-INF/config/template");
    private SchemaBuilder schemaBuilder = null;
    private String groupOwnerDirectory = null;

    @Override
    public Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Group group;
        String schemaname = parent.getParameter("schema");
        if (schemaname == null) {
            throw new ActionException("Parameter schema is required", true);
        }
        String groupname = parent.getGroupName();
        if (groupname == null) {
            throw new ActionException("Group is required");
        }
        String documenttype = parent.getParameter("document-type");
        try {
            group = GroupRule.getGroup((Database)db, (String)groupname);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + groupname + ": " + e.getMessage());
        }
        if (group == null) {
            throw new ActionException("Invalid group " + groupname);
        }
        this.groupOwnerDirectory = group.getOwnerDirectory() == null ? "default" : group.getOwnerDirectory();
        File output = this.initSchemaFile(schemaname, documenttype);
        this.schemaBuilder = new SchemaBuilder(parent.getMemberUsername(), group, output);
        return this.schemaBuilder;
    }

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new AdminSystemCheck();
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        try {
            this.schemaBuilder.addURI(uri, db);
        }
        catch (URIException e) {
            throw new ActionException("Failed to read URI's content", e);
        }
    }

    private File initSchemaFile(String name, String doctype) {
        String path = this.groupOwnerDirectory + File.separator + (Strings.isEmpty((String)doctype) ? "document" + File.separator + "psml" : "psml" + File.separator + RuleUtils.replaceNonFilenameChars((String)doctype)) + File.separator + RuleUtils.replaceNonFilenameChars((String)name.replace(' ', '_'));
        File schemaFile = new File(TEMPLATE_FOLDER, path + ".sch");
        int i = 1;
        while (schemaFile.exists()) {
            schemaFile = new File(TEMPLATE_FOLDER, path + "_" + i++ + ".sch");
        }
        return schemaFile;
    }

    static class SchemaBuilder
    extends ProcessThread {
        private final File outputFile;
        private final UsageReportBuilder reporter;
        private final ByteArrayOutputStream log;
        private boolean created = false;

        private SchemaBuilder(String username, Group group, File output) {
            super(username, "Generating usage schema", group);
            this.outputFile = output;
            this.reporter = new UsageReportBuilder();
            this.log = new ByteArrayOutputStream();
            this.reporter.setLog(new PrintStream(this.log));
        }

        public void addURI(URI uri, Database db) throws URIException {
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), this.getGroup());
            this.reporter.parseStream(resolver.getContent(db));
        }

        public void process() {
            this.outputFile.getParentFile().mkdirs();
            try {
                if (!this.outputFile.createNewFile()) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to create new schema file " + Files.path((File)TEMPLATE_FOLDER, (File)this.outputFile));
                    return;
                }
            }
            catch (IOException ex) {
                try {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to create new schema file " + Files.path((File)TEMPLATE_FOLDER, (File)this.outputFile) + ": " + ex.getMessage());
                }
                catch (IOException e) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to compute schema file's path: " + e.getMessage());
                }
                return;
            }
            this.reporter.saveSchematronFile(this.outputFile);
            this.created = true;
            this.complete("Usage schema was successfully generated");
        }

        public void writeThreadElements(OutputPrinter out) {
            if (!this.created) {
                return;
            }
            out.startObject("usage-schema");
            try {
                byte[] errors = this.log.toByteArray();
                if (errors.length > 0) {
                    out.field("status", "error");
                    out.field("errors", new String(errors, StandardCharsets.UTF_8), OutputPrinter.FieldOption.XML_ELEMENT);
                } else {
                    out.field("status", "success");
                    out.field("name", this.outputFile.getName());
                }
            }
            finally {
                out.endObject();
            }
        }
    }
}

