/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.AntiCSRFToken;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.publish.Publisher;
import java.util.Map;

public final class URIPublish
implements Action<URI> {
    private Publisher publisher = null;

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new ViewURICheck(uri);
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return false;
    }

    @Override
    public Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        String downloadWorking;
        Member author;
        Group group;
        try {
            group = GroupRule.getGroup((Database)db, (String)parent.getGroupName());
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + parent.getGroupName() + ": " + e.getMessage());
        }
        if (group == null) {
            throw new ActionException("Invalid group " + parent.getGroupName());
        }
        try {
            author = DatabaseQuery.getMemberById((Database)db, (Long)parent.getMemberID());
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load member: " + ex.getMessage(), ex);
        }
        this.publisher = new Publisher(Publisher.PublisherAction.PUBLISH);
        String sessionid = parent.getParameter("sessionid");
        this.publisher.setJsessionid(sessionid);
        this.publisher.setSourceType("batch");
        this.publisher.setGroup(group);
        this.publisher.setUsername(author.getUsername());
        this.publisher.setUserID(author.getId().toString());
        this.publisher.setUserFirstname(author.getFirstName());
        this.publisher.setUserSurname(author.getSurname());
        this.publisher.setUserToken(parent.getUserToken());
        this.publisher.setAntiCSRFToken(AntiCSRFToken.generateToken((String)sessionid));
        this.publisher.setConfigProjectName(parent.getParameter("project"));
        this.publisher.setActionType(parent.getParameter("type"));
        this.publisher.setTarget(parent.getParameter("target"));
        this.publisher.setParameter("ps-started", String.valueOf(System.currentTimeMillis()));
        String logLevel = parent.getParameter("log-level");
        if (logLevel != null) {
            this.publisher.setParameter("log-level", logLevel);
        }
        if ((downloadWorking = parent.getParameter("download-working")) != null) {
            this.publisher.setParameter("download-working", downloadWorking);
        }
        for (Map.Entry<String, String> param : parent.getParametersPrefix("param.").entrySet()) {
            this.publisher.setParameter("ps-param-" + param.getKey(), param.getValue());
        }
        Map<String, String> searchParameters = parent.getParametersPrefix("search.");
        this.publisher.setParameter("ps-searchFilters", searchParameters.get("filters"));
        this.publisher.setParameter("ps-searchQuestion", searchParameters.get("question"));
        this.publisher.setParameter("ps-searchQuestionFields", searchParameters.get("questionfields"));
        this.publisher.setParameter("ps-searchRanges", searchParameters.get("ranges"));
        return this.publisher;
    }

    @Override
    public void addObject(URI u, Database db) {
        this.publisher.addUriId(u.getId());
    }
}

