/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.publish.Publisher;
import com.pageseeder.uri.MoveURIThread;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;

public final class URIArchive
implements Action<URI> {
    private static final int MAX_COUNTER = 1000000000;
    private String archiveRoot = null;
    private String archivePath = null;
    private MoveURIThread thread = null;
    private final Collection<String> destinationNames = new ArrayList<String>();

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new EditURICheck(uri);
    }

    @Override
    public Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Member author;
        GroupURI guri;
        Group group;
        try {
            group = GroupRule.getGroup((Database)db, (String)parent.getGroupName());
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + parent.getGroupName() + ": " + e.getMessage());
        }
        if (group == null) {
            throw new ActionException("Invalid group " + parent.getGroupName());
        }
        try {
            guri = GroupURIRule.getDefaultGroupURI((Group)group);
            if (guri == null) {
                throw new ActionException("There is no default Group URI.");
            }
        }
        catch (GetCollectionException e) {
            throw new ActionException("Failed to compute default Group URI: " + e.getMessage());
        }
        this.archiveRoot = GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/archive";
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        int month = now.get(2) + 1;
        this.archivePath = this.archiveRoot + "/" + now.get(1);
        this.getFolderForSchemeHostPortPath(db, tr, guri.getScheme(), guri.getHost().getName(), guri.getPort(), this.archivePath);
        this.archivePath = this.archivePath + "/" + (month < 10 ? "0" : "") + month;
        this.getFolderForSchemeHostPortPath(db, tr, guri.getScheme(), guri.getHost().getName(), guri.getPort(), this.archivePath);
        try {
            author = DatabaseQuery.getMemberById((Database)db, (Long)parent.getMemberID());
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load member " + parent.getMemberID() + ": " + e.getMessage());
        }
        if (author == null) {
            throw new ActionException("Invalid author " + parent.getMemberID());
        }
        this.thread = MoveURIThread.newInstance(true, author.getUsername(), group);
        this.thread.setDestinationDetails(guri.getScheme(), guri.getHost().getName(), guri.getPort(), this.archivePath);
        this.thread.setCommentGroups(Collections.singletonList(group.getName()));
        this.thread.setRemoveXRefs("true".equals(parent.getParameter(StandardParameters.removexrefs.name())));
        return this.thread;
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        try {
            if (URIs.isExternal((URI)uri)) {
                throw new ActionException("Use archiveurl action for URLs.", true);
            }
            if (this.archiveRoot.equalsIgnoreCase(uri.getPath())) {
                throw new ActionException("The 'archive' folder for a group cannot be removed.", true);
            }
            if (uri.getPath().startsWith(this.archiveRoot + "/")) {
                throw new ActionException("The URI " + uri.getDecodedPath() + " is already archived.", true);
            }
            this.thread.addURIToMove(uri.getId(), this.findArchiveName(db, uri));
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Error while accessing the database: " + ex.getMessage(), ex);
        }
    }

    private String findArchiveName(Database db, URI uri) throws QueryFailedException {
        String[] oldFilename = URIRule.getFilename((URI)uri);
        boolean filter = URIs.isExternal((URI)uri);
        String archiveFilename = oldFilename[0] + oldFilename[1];
        for (int i = 1; i < 1000000000; ++i) {
            URI turi;
            String real_path;
            boolean exists = this.destinationNames.contains(archiveFilename);
            if (!exists && !filter && new File(real_path = URIRule.getRealPath((String)Settings.getContextPath(), (String)(this.archivePath + "/" + archiveFilename))).exists()) {
                exists = true;
            }
            if (!exists && (turi = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)URLCoder.encode((String)(this.archivePath + "/" + archiveFilename)).replaceAll("%2F", "/"))) != null) {
                exists = true;
            }
            if (!exists) break;
            archiveFilename = oldFilename[0] + "-" + i + oldFilename[1];
        }
        this.destinationNames.add(archiveFilename);
        return archiveFilename.replaceAll("\\.[^\\.]*?$", "");
    }

    private URI getFolderForSchemeHostPortPath(Database db, Transaction tr, String scheme, String host, Integer port, String path) throws ActionException {
        try {
            URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)path);
            if (uri == null) {
                uri = URIRule.createURIForSchemeHostPortPathType((Database)db, (Transaction)tr, (String)scheme, (String)host, (Integer)port, (String)path, (String)"folder");
                if (uri == null) {
                    throw new ActionException("No group URI for: " + scheme + "://" + host + ":" + path);
                }
                String real_path = URIRule.getRealPath((String)Settings.getContextPath(), (String)path);
                if (!new File(real_path).mkdir()) {
                    throw new ActionException("Unable to create directory for: " + scheme + "://" + host + ":" + path);
                }
            }
            return uri;
        }
        catch (DatabaseException ex) {
            throw new ActionException("Unable to get URI for: " + scheme + "://" + host + ":" + path);
        }
    }
}

