/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.publish.Publisher;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.version.CreateVersionThread;
import java.util.Date;

public final class URIAddVersion
implements Action<URI> {
    private static final int MAX_VERSION_NOTIFICATION_PSML = 20;
    private CreateVersionThread thread = null;
    private Group group = null;

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new AddVersionCheck(this.group, uri);
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        String title;
        Member author;
        try {
            this.group = GroupRule.getGroup((Database)db, (String)parent.getGroupName());
            if (this.group == null) {
                throw new ActionException("Failed to load group " + parent.getGroupName());
            }
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load group " + parent.getGroupName(), ex);
        }
        try {
            author = DatabaseQuery.getMemberById((Database)db, (Long)parent.getMemberID());
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load member: " + ex.getMessage(), ex);
        }
        Notify notify = Notify.SILENT;
        int maxPSML = GlobalSettings.getInt((String)"maxVersionNotifications", (int)20);
        if (parent.getTotalIDs() <= maxPSML && (notify = Notify.fromString((String)parent.getParameter(StandardParameters.notify.getName()))) == Notify.UNKNOWN) {
            notify = Notify.SILENT;
        }
        String content = parent.getParameter("content");
        String[] labels = null;
        String labelsStr = parent.getParameter("labels");
        if (!URIUtils.checkLabels(null, labelsStr)) {
            throw new ActionException("labels parameter invalid", true);
        }
        if (labelsStr != null && labelsStr.length() > 0) {
            labels = Strings.split((String)labelsStr, (char)',');
        }
        if ((title = parent.getParameter("title")) == null || title.length() <= 0) {
            throw new ActionException("title parameter is missing.", true);
        }
        CreateVersionThread.Version version = new CreateVersionThread.Version(title, author, new Date(), false, this.group, content, labels, notify, null);
        this.thread = new CreateVersionThread(parent.getMemberUsername(), this.group, null, version);
        return this.thread;
    }

    @Override
    public Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public void addObject(URI uri, Database db) {
        this.thread.addURI(uri.getId());
    }
}

