/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.action.ActionUtils;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.SearchBase;
import com.pageseeder.search.queries.PageSeederQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(member=true, group=true, parameters={"object", "action"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class RunBatchActionOnSearchResults
extends SearchBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunBatchActionOnSearchResults.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewGroupCheck(req.getGroup()));
    }

    protected void finishNoIndexes(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("batch-action");
        out.field("name", req.getParameter((Parameter)StandardParameters.action));
        out.field("object", req.getParameter((Parameter)StandardParameters.object));
        out.field("indexes", "");
        out.endObject();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(GeneratorRequest req, List<Index> indexes, List<Group> groups, PageSeederQuery query, SearchBase.AllFacets facets, int facetSize, String warning, Catalog catalog, Analyzer analyser, boolean addURLsFilter, GeneratorResponse res) throws IOException {
        ActionProcessor.ActionResult result;
        String object = req.getParameter((Parameter)StandardParameters.object);
        String action = req.getParameter((Parameter)StandardParameters.action);
        ActionProcessor<? extends DBObject> processor = ActionUtils.createProcessor(req, res);
        if (processor == null) {
            return;
        }
        int max = GlobalSettings.getInt((String)"maxPageSize", (int)10000);
        ArrayList<Long> ids = new ArrayList<Long>();
        SearchResults results = null;
        try {
            results = LuceneIndexQueries.query(indexes, (SearchQuery)query, (SearchPaging)new SearchPaging(1, max + 1));
            if (results.getTotalNbOfResults() > max) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Too many results (more than maxPageSize global property: " + max + ")");
                return;
            }
            List<String> filtersParam = Arrays.asList(Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\'));
            boolean tasks = filtersParam.contains("pstype:task") || filtersParam.contains("+pstype:task");
            for (ScoreDoc doc : results.getScoreDoc()) {
                String defid;
                Document result2 = results.getDocument(doc.doc);
                if (result2 == null) continue;
                String id = result2.get("psid");
                if (tasks && (defid = result2.get("pstaskdefinitionid")) != null) {
                    id = defid;
                }
                String type = result2.get("pstype");
                if ("uri".equals(object) && !"document".equals(type) && !"url".equals(type) && !"folder".equals(type) || "xlink".equals(object) && !"task".equals(type) && !"comment".equals(type)) {
                    LOGGER.warn("Search result {} with type {} does not match object {}", new Object[]{id, type, object});
                    res.setError(GeneratorStatus.BAD_REQUEST, "Search result " + id + " with type " + type + " does not match object " + object);
                    return;
                }
                if (Strings.isDigits((String)id)) {
                    ids.add(Long.valueOf(id));
                    continue;
                }
                LOGGER.warn("Ignoring search result with invalid id {}", (Object)id);
            }
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to search index", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to run query " + query.toString() + ": " + ex.getMessage());
            return;
        }
        finally {
            if (results != null) {
                results.terminate();
            }
        }
        try {
            result = processor.execute(ids.toArray(new Long[0]));
        }
        catch (ActionException ex) {
            res.setError(ex.isClientError() ? GeneratorStatus.BAD_REQUEST : GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        Collection<Long> forbidden = result.getDisallowed();
        if (!forbidden.isEmpty()) {
            String msg = "Forbidden for " + forbidden.size() + " object" + (forbidden.size() == 1 ? "" : "s") + ": " + forbidden.stream().map(Object::toString).collect(Collectors.joining(", "));
            res.setError(GeneratorStatus.FORBIDDEN, msg);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("batch-action");
        out.field("name", action);
        out.field("object", object);
        out.field("ids", Stream.of(ids).map(Object::toString).collect(Collectors.joining(",")));
        if (result.getPublisherResponse() != null) {
            out.field("publisherxml", result.getPublisherResponse(), OutputPrinter.FieldOption.XML_COPY);
        } else if (result.getThread() != null) {
            result.getThread().print((OutputPrinter)out);
        }
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    protected void addETagValues(GeneratorRequest req, StringBuilder etag) {
        for (Map.Entry param : req.getParameters().entrySet()) {
            String pname = (String)param.getKey();
            if (!StandardParameters.action.getName().equals(pname) && !StandardParameters.object.getName().equals(pname) && !((String)param.getKey()).startsWith("action.")) continue;
            etag.append(',').append(pname).append('=').append((String)param.getValue());
        }
    }

    protected boolean addSort(GeneratorRequest req, GeneratorResponse res, Catalog catalog, PageSeederQuery.Builder builder) {
        return true;
    }

    protected boolean supportPredicate() {
        return false;
    }
}

