/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.Initialize;
import com.pageseeder.InitializeThread;
import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.mail.MailHosts;
import com.pageseeder.member.Members;
import com.pageseeder.webhook.manager.WebhookManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class Setup
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Setup.class);
    private static final String DB_URL_PROPERTY = "DBURL";
    private static final String DB_LOGIN_NAME_PROPERTY = "LoginName";
    private static final String DB_LOGIN_PASSWORD_PROPERTY = "LoginPassword";
    private static final String DB_TYPE_PROPERTY = "DatabaseType";
    private static final String DB_HOST_PROPERTY = "HostName";
    private static final String DB_NAME_PROPERTY = "DatabaseName";
    private static final long serialVersionUID = -2727009870527377816L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        long start = System.currentTimeMillis();
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        String db_url = DatabaseSettings.get((String)DB_URL_PROPERTY);
        String login_name = DatabaseSettings.get((String)DB_LOGIN_NAME_PROPERTY);
        String login_password = DatabaseSettings.getPassword();
        boolean product_invalid = false;
        if (!Strings.isEmpty((String)db_url)) {
            Database db;
            try {
                db = Database.open();
            }
            catch (OpenDatabaseException ex) {
                this.sendError(req, res, "Error when connecting to database", ex);
                return;
            }
            Transaction tr = new Transaction(db);
            try {
                tr.begin();
                Permissions perm = new Permissions();
                if (req.getAttribute("com.pageseeder.layout") == Boolean.TRUE) {
                    if (!PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)perm, (PermissionCheck)new AdminSystemCheck(false))) {
                        res.setStatus(perm.isLoggedIn() ? 403 : 401);
                        tr.abort();
                        return;
                    }
                } else if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminSystemCheck(false))) {
                    tr.abort();
                    return;
                }
                product_invalid = !PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)perm, (PermissionCheck)new NoCheck());
                tr.commit();
            }
            catch (StartTransactionException ex) {
                this.sendError(req, res, "Error when connecting to database", ex);
            }
            catch (DatabaseException ex) {
                tr.abort();
                this.sendError(req, res, "Error checking permissions", ex);
            }
            finally {
                db.close();
            }
        }
        this.writeResponse(req, res, product_invalid, false);
        WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"setup", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse res, boolean product_invalid, boolean login_required) throws IOException {
        String productkey = GlobalSettings.getString((String)"productKey", (String)"");
        UniversalPrinter out = WebUtilities.getUniversalPrinter((HttpServletRequest)req, (HttpServletResponse)res);
        out.startObject("setup");
        out.field("licenseexpired", SecurityUtils.isLicenseExpired(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("loginrequired", login_required, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("productkeyinvalid", product_invalid, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("organizationdisabled", OrganizationManager.instance().isDisabled(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("organizationerror", OrganizationManager.instance().hasError(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("smtpserveraddress", GlobalSettings.getString((String)"smtpServerAddress", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("smtpserverport", GlobalSettings.getString((String)"smtpServerPort", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("smtpserverusername", GlobalSettings.getString((String)"smtpServerUsername", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("smtpserverssl", GlobalSettings.getString((String)"smtpServerSSL", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("smtpserverstarttls", GlobalSettings.getString((String)"smtpServerSTARTTLS", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("productkey", productkey, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("projects", GlobalSettings.getString((String)"projects", (String)"unlimited"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("groups", GlobalSettings.getString((String)"groups", (String)"unlimited"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("members", GlobalSettings.getString((String)"members", (String)"unlimited"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("licenseexpires", GlobalSettings.getString((String)"licenseExpires", (String)""), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("websiteaddress", GlobalSettings.get((String)"webSiteAddress"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("websitescheme", GlobalSettings.get((String)"webSiteScheme"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("websiteport", GlobalSettings.get((String)"webSitePort"), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("emaildomain", GlobalSettings.get((String)"emailDomain"), OutputPrinter.FieldOption.XML_ELEMENT);
        String database_type = DatabaseSettings.get((String)DB_TYPE_PROPERTY);
        String host_name = DatabaseSettings.get((String)DB_HOST_PROPERTY);
        String database_name = DatabaseSettings.get((String)DB_NAME_PROPERTY);
        String login_name = DatabaseSettings.get((String)DB_LOGIN_NAME_PROPERTY);
        String db_url = DatabaseSettings.getString((String)DB_URL_PROPERTY, (String)"");
        String gen_db_url = this.generateDBURL(database_type, host_name, database_name);
        out.field("dbtype", database_type, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("dbhostname", host_name, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("dbname", database_name, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("dbloginname", login_name, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("dburldefault", gen_db_url, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("dburl", db_url, OutputPrinter.FieldOption.XML_ELEMENT);
        out.endObject();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean product_invalid;
        Permissions perm;
        Transaction tr;
        Database db;
        String licenseExpires;
        String members;
        String groups;
        String projects;
        String product_key;
        String web_site_port;
        String web_site_scheme;
        long start = System.currentTimeMillis();
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        String database_type = this.getParameterLegacy(req, "dbtype", DB_TYPE_PROPERTY);
        String host_name = this.getParameterLegacy(req, "dbhostname", DB_HOST_PROPERTY);
        String database_name = this.getParameterLegacy(req, "dbname", DB_NAME_PROPERTY);
        String custom_db_url = this.getParameterLegacy(req, "dburl", DB_URL_PROPERTY);
        String new_login_name = this.getParameterLegacy(req, "dbloginname", DB_LOGIN_NAME_PROPERTY);
        String new_login_password = this.getParameterLegacy(req, "dbloginpassword", DB_LOGIN_PASSWORD_PROPERTY);
        String dba_login_name = this.getParameterLegacy(req, "dbaloginname", "DBALoginName");
        String dba_login_password = this.getParameterLegacy(req, "dbaloginpassword", "DBALoginPassword");
        String update_database_param = this.getParameterLegacy(req, "updatedatabase", "updateDatabase");
        boolean update_database = "true".equals(update_database_param) || "yes".equals(update_database_param);
        String create_database_param = this.getParameterLegacy(req, "createdatabase", "createDatabase");
        boolean create_database = "true".equals(create_database_param) || "yes".equals(create_database_param);
        String create_tables_param = this.getParameterLegacy(req, "createtables", "createTables");
        boolean create_tables = "true".equals(create_tables_param) || "yes".equals(create_tables_param);
        String smtp_server_address = this.getParameterLegacy(req, "smtpserveraddress", "smtpServerAddress");
        String smtp_server_port = req.getParameter("smtpserverport");
        String smtp_server_username = req.getParameter("smtpserverusername");
        String smtp_server_password = req.getParameter("smtpserverpassword");
        boolean smtp_server_ssl = "true".equals(req.getParameter("smtpserverssl"));
        boolean smtp_server_starttls = "true".equals(req.getParameter("smtpserverstarttls"));
        String current_web_site_address = GlobalSettings.getString((String)"webSiteAddress", (String)"");
        String web_site_address = this.getParameterLegacy(req, "websiteaddress", "webSiteAddress");
        if (web_site_address == null) {
            web_site_address = current_web_site_address;
        }
        if ((web_site_scheme = this.getParameterLegacy(req, "websitescheme", "webSiteScheme")) == null) {
            web_site_scheme = GlobalSettings.getString((String)"webSiteScheme", (String)"");
        }
        if ((web_site_port = this.getParameterLegacy(req, "websiteport", "webSitePort")) == null) {
            web_site_port = GlobalSettings.getString((String)"webSitePort", (String)"");
        }
        String current_email_domain = GlobalSettings.getString((String)"emailDomain", (String)"");
        String email_domain = this.getParameterLegacy(req, "emaildomain", "emailDomain");
        if (email_domain == null) {
            email_domain = current_email_domain;
        }
        if ((product_key = this.getParameterLegacy(req, "productkey", "productKey")) == null) {
            product_key = GlobalSettings.getString((String)"productKey", (String)"");
        }
        if ((projects = req.getParameter("projects")) == null) {
            projects = GlobalSettings.getString((String)"projects", (String)"unlimited");
        }
        if ((groups = req.getParameter("groups")) == null) {
            groups = GlobalSettings.getString((String)"groups", (String)"unlimited");
        }
        if ((members = req.getParameter("members")) == null) {
            members = GlobalSettings.getString((String)"members", (String)"unlimited");
        }
        if ((licenseExpires = this.getParameterLegacy(req, "licenseexpires", "licenseExpires")) == null) {
            licenseExpires = GlobalSettings.getString((String)"licenseExpires", (String)"");
        }
        String create_db_url = null;
        String db_url = DatabaseSettings.get((String)DB_URL_PROPERTY);
        String db_driver = DatabaseSettings.get((String)"DBDriver");
        String login_name = DatabaseSettings.get((String)DB_LOGIN_NAME_PROPERTY);
        String login_password = DatabaseSettings.getPassword();
        String admin_first = this.getParameterLegacy(req, "adminfirstname", "AdminFirstName");
        String admin_surname = this.getParameterLegacy(req, "adminsurname", "AdminSurname");
        String admin_username = this.getParameterLegacy(req, "adminusername", "AdminUsername");
        String admin_email = this.getParameterLegacy(req, "adminemail", "AdminEmail");
        String admin_password = this.getParameterLegacy(req, "adminpassword", "AdminPassword");
        if (Strings.isEmpty((String)web_site_address) || Strings.isEmpty((String)product_key) || Strings.isEmpty((String)projects) || Strings.isEmpty((String)groups) || Strings.isEmpty((String)members) || update_database && (Strings.isEmpty((String)database_type) || Strings.isEmpty((String)new_login_name) || Strings.isEmpty((String)custom_db_url) && (Strings.isEmpty((String)host_name) || Strings.isEmpty((String)database_name))) || create_database && (Strings.isEmpty((String)host_name) || Strings.isEmpty((String)database_name))) {
            res.sendError(400, "One or more parameters is missing.");
            return;
        }
        if (create_database && update_database && !SecurityUtils.isPasswordAtLeast((String)new_login_password, (String)"STRONG")) {
            res.sendError(400, "The DB Login password must be at least Strong.");
            return;
        }
        if (create_tables && update_database) {
            if (!Emails.isAddress((String)admin_email)) {
                res.sendError(400, "Invalid admin email address");
                return;
            }
            if (admin_password == null || admin_password.length() == 0) {
                res.sendError(400, "Admin password cannot be empty");
                return;
            }
            if (!SecurityUtils.isPasswordAtLeast((String)admin_password, (String)"STRONG")) {
                res.sendError(400, "Admin password is too weak");
                return;
            }
            if (admin_password.equals(admin_username)) {
                res.sendError(400, "Admin password cannot be the same as the username");
                return;
            }
            if (admin_username != null && admin_username.length() != 0 && !Members.USERNAME.matcher(admin_username).matches()) {
                res.sendError(400, "Admin username allows letters, numbers, '.', '_', '-' (can't be all numbers)");
                return;
            }
            if (Strings.isEmpty((String)admin_first) || Strings.isEmpty((String)admin_surname)) {
                res.sendError(400, "Admin first name and admin surname are required.");
                return;
            }
        }
        boolean login_required = false;
        if (!Strings.isEmpty((String)db_url)) {
            try {
                db = Database.open();
            }
            catch (OpenDatabaseException ex) {
                this.sendError(req, res, "Error when connecting to database", ex);
                return;
            }
            tr = new Transaction(db);
            try {
                tr.begin();
                perm = new Permissions();
                if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminSystemCheck(false))) {
                    tr.abort();
                    return;
                }
                if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                    res.sendError(419, "Missing correct CSRF token");
                    tr.abort();
                    return;
                }
                tr.commit();
            }
            catch (StartTransactionException ex) {
                this.sendError(req, res, "Error when connecting to database", ex);
                return;
            }
            catch (DatabaseException ex) {
                tr.abort();
                this.sendError(req, res, "Error when checking permissions", ex);
                return;
            }
            finally {
                db.close();
            }
        }
        try {
            block138: {
                Connection con;
                if (smtp_server_address != null && !smtp_server_address.isEmpty()) {
                    LOGGER.info("Testing SMTP server: '{}'", (Object)smtp_server_address);
                    String existingServer = GlobalSettings.getString((String)"smtpServerAddress", (String)"");
                    String existingPort = GlobalSettings.getString((String)"smtpServerPort", (String)GlobalSettings.getString((String)"mailPort", (String)"25"));
                    String existingUsername = GlobalSettings.getString((String)"smtpServerUsername", (String)"");
                    String existingPassword = GlobalSettings.getString((String)"smtpServerPassword", (String)"");
                    if (!existingServer.equals(smtp_server_address) || !existingPort.equals(smtp_server_port) || !existingUsername.equals(smtp_server_username) || smtp_server_password != null && !existingPassword.equals(smtp_server_password)) {
                        try {
                            int port = Integer.parseInt(Strings.isEmpty((String)smtp_server_port) ? "25" : smtp_server_port);
                            Socket mail_socket = new Socket(smtp_server_address, port);
                            LOGGER.debug("SMTP server socket: '{}'", (Object)mail_socket.getLocalSocketAddress());
                            PrintWriter mail_out = new PrintWriter(mail_socket.getOutputStream(), true);
                            BufferedReader mail_in = new BufferedReader(new InputStreamReader(mail_socket.getInputStream()));
                            mail_in.readLine();
                            mail_out.println("QUIT");
                            mail_in.readLine();
                            mail_socket.close();
                        }
                        catch (NumberFormatException ex) {
                            this.sendError(req, res, "Invalid value for SMTP server port", ex);
                            return;
                        }
                        catch (IOException ex) {
                            this.sendError(req, res, "Error when testing the Mail Server", ex);
                            return;
                        }
                    }
                }
                if (update_database) {
                    login_name = new_login_name;
                    if (new_login_password != null && !"".equals(new_login_password)) {
                        login_password = new_login_password;
                    }
                    if ("MySQL".equals(database_type)) {
                        db_driver = "com.mysql.cj.jdbc.Driver";
                        try {
                            Class.forName(db_driver);
                        }
                        catch (ClassNotFoundException ex) {
                            db_driver = "com.mysql.jdbc.Driver";
                        }
                        db_url = this.generateDBURL(database_type, host_name, database_name);
                        create_db_url = "jdbc:mysql://" + host_name + "?allowPublicKeyRetrieval=true";
                    } else if ("PostgreSQL".equals(database_type)) {
                        db_driver = "org.postgresql.Driver";
                        db_url = this.generateDBURL(database_type, host_name, database_name);
                        create_db_url = "jdbc:postgresql://" + host_name + "/";
                    }
                    if (!Strings.isEmpty((String)custom_db_url)) {
                        db_url = custom_db_url;
                    }
                    this.renameJDOPackageFile(database_type, "/com/pageseeder/db/model");
                    this.renameJDOPackageFile(database_type, "/com/pageseeder/db/oauth");
                    Class.forName(db_driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    con = null;
                    if (create_database && create_db_url != null) {
                        con = DriverManager.getConnection(create_db_url, dba_login_name, dba_login_password);
                    } else if (!Strings.isEmpty((String)db_url)) {
                        con = DriverManager.getConnection(db_url, login_name, login_password);
                    }
                    if (con != null) {
                        con.close();
                    }
                }
                if (create_database && update_database && create_db_url != null && login_password != null) {
                    Class.forName(db_driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    con = DriverManager.getConnection(create_db_url, dba_login_name, dba_login_password);
                    try {
                        String escaped_password;
                        if ("MySQL".equals(database_type)) {
                            escaped_password = login_password.replace("'", "\\'");
                            this.executeSQL(con, "create database " + database_name + " character set utf8mb4;");
                            String dbUser = new_login_name + "@" + ("localhost".equals(host_name) ? "localhost" : "\"%\"");
                            this.executeSQL(con, "create user " + dbUser + " identified by '" + escaped_password + "'", escaped_password);
                            this.executeSQL(con, "grant all on " + database_name + ".* to " + dbUser, escaped_password);
                        } else if ("PostgreSQL".equals(database_type)) {
                            escaped_password = login_password.replace("'", "''");
                            this.executeSQL(con, "create database " + database_name + " encoding 'UTF8' lc_collate = 'en_US.UTF-8' lc_ctype = 'en_US.UTF-8' template template0;");
                            this.executeSQL(con, "create user " + new_login_name + " encrypted password '" + escaped_password + "'", escaped_password);
                            this.executeSQL(con, "grant connect on database " + database_name + " to " + new_login_name);
                        }
                    }
                    finally {
                        try {
                            con.close();
                        }
                        catch (SQLException ex) {
                            LOGGER.error("Unable to close connection", (Throwable)ex);
                        }
                    }
                    if ("PostgreSQL".equals(database_type)) {
                        con = DriverManager.getConnection(db_url, dba_login_name, dba_login_password);
                        try {
                            this.executeSQL(con, "grant create on schema public to " + new_login_name);
                        }
                        finally {
                            try {
                                con.close();
                            }
                            catch (SQLException ex) {
                                LOGGER.error("Unable to close connection", (Throwable)ex);
                            }
                        }
                    }
                }
                if (create_tables && update_database && !Strings.isEmpty((String)db_url)) {
                    Object base_path = this.getServletConfig().getServletContext().getRealPath("/");
                    if (!((String)base_path).endsWith(File.separator)) {
                        base_path = (String)base_path + File.separator;
                    }
                    base_path = (String)base_path + "WEB-INF" + File.separator + "sql";
                    File file = Files.descendantFile((File)new File((String)base_path), (String)(database_type + ".sql"));
                    Class.forName(db_driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1));
                    try (Connection con2 = DriverManager.getConnection(db_url, login_name, login_password);){
                        String line;
                        while ((line = in.readLine()) != null) {
                            StringBuilder sql = new StringBuilder();
                            while (line != null && !"".equals(line)) {
                                sql.append(line);
                                line = in.readLine();
                            }
                            String sql_string = sql.toString();
                            if (sql_string.endsWith(";")) {
                                sql_string = sql_string.substring(0, sql_string.length() - 1);
                            }
                            if ("".equals(sql_string)) continue;
                            this.executeSQL(con2, sql_string);
                        }
                        break block138;
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            LOGGER.error("Unable to close file/connection", (Throwable)ex);
                        }
                    }
                }
                if (update_database && !Strings.isEmpty((String)db_url)) {
                    Class.forName(db_driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    con = DriverManager.getConnection(db_url, login_name, login_password);
                    try {
                        Statement s = con.createStatement();
                        LOGGER.info("Retrieving DB version");
                        ResultSet rs = s.executeQuery("SELECT Version FROM DATABASE_METADATA");
                        if (!rs.next()) {
                            res.sendError(400, "Invalid database, cannot retrieve database version");
                            return;
                        }
                        String version = rs.getString(1);
                        LOGGER.info("Found version : {}", (Object)version);
                        if (version != null && version.equals("6.20")) break block138;
                        res.sendError(400, "Invalid database, database version " + version + " does not match current version 6.20");
                        return;
                        {
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (s != null) {
                                s.close();
                            }
                        }
                    }
                    finally {
                        if (con != null) {
                            con.close();
                        }
                    }
                }
            }
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"productKey", (String)product_key);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"projects", (String)projects);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"groups", (String)groups);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"members", (String)members);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"licenseExpires", (String)licenseExpires);
            if (smtp_server_address != null) {
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerAddress", (String)smtp_server_address);
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerPort", (String)smtp_server_port);
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerUsername", (String)smtp_server_username);
                if (smtp_server_password != null) {
                    Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerPassword", (String)smtp_server_password);
                }
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerSSL", (String)(smtp_server_ssl ? "true" : "false"));
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"smtpServerSTARTTLS", (String)(smtp_server_starttls ? "true" : "false"));
            }
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"webSiteAddress", (String)web_site_address);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"webSiteScheme", (String)web_site_scheme);
            Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"webSitePort", (String)web_site_port);
            if (Strings.isEmpty((String)email_domain)) {
                Settings.remove((SettingsFile)SettingsFile.GLOBAL, (String)"emailDomain");
            } else {
                Settings.set((SettingsFile)SettingsFile.GLOBAL, (String)"emailDomain", (String)email_domain);
            }
            Settings.save((SettingsFile)SettingsFile.GLOBAL);
            if (update_database && login_password != null) {
                Database.closeAll();
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)"DBDriver", (String)db_driver);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_URL_PROPERTY, (String)db_url);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_TYPE_PROPERTY, (String)database_type);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_HOST_PROPERTY, (String)host_name);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_NAME_PROPERTY, (String)database_name);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_LOGIN_NAME_PROPERTY, (String)login_name);
                DatabaseSettings.setPassword((String)login_password);
                Settings.save((SettingsFile)SettingsFile.DATABASE);
                Settings.load((SettingsFile)SettingsFile.JDO, (String)Settings.getContextPath());
                Database.reloadConfig();
            }
            if (!web_site_address.equals(current_web_site_address)) {
                InitializeThread.reportToLicenseServer();
            }
            if (!email_domain.equals(current_email_domain) || !web_site_address.equals(current_web_site_address)) {
                Initialize.stopMail();
                Initialize.initMail();
            }
            try {
                db = Database.open();
            }
            catch (OpenDatabaseException ex) {
                this.sendError(req, res, "Error when opening the Database", ex);
                return;
            }
            tr = new Transaction(db);
            try {
                tr.begin();
                if (update_database) {
                    login_required = true;
                    if (create_tables) {
                        login_required = Setup.createAdmin(admin_first, admin_surname, admin_username, admin_email, admin_password, db, tr, req);
                    } else {
                        WebhookManager.getInstance().reloadEventFilters(db);
                    }
                    WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"setup", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
                    SecurityUtils.logout((Database)db, (HttpServletRequest)req, (HttpServletResponse)res);
                }
                product_invalid = !PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)(perm = new Permissions()), (PermissionCheck)new NoCheck());
                tr.commit();
            }
            catch (StartTransactionException ex) {
                this.sendError(req, res, "Error when opening the Database", ex);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_URL_PROPERTY, (String)"");
                return;
            }
            catch (DatabaseException ex) {
                this.sendError(req, res, "Database error", ex);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_URL_PROPERTY, (String)"");
                return;
            }
            catch (IOException ex) {
                tr.abort();
                this.sendError(req, res, "Admin creation error", ex);
                Settings.set((SettingsFile)SettingsFile.DATABASE, (String)DB_URL_PROPERTY, (String)"");
                return;
            }
            finally {
                db.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Setup Error", (Throwable)ex);
            res.sendError(400, "The following error occurred during setup: " + (String)(!"java.lang.Exception".equals(ex.getClass().getName()) ? ex.getClass().getName() + ": " : "") + ex.getMessage());
            WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"setup", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
            return;
        }
        OrganizationManager.instance().load();
        this.writeResponse(req, res, product_invalid, login_required);
    }

    private String generateDBURL(String database_type, String host_name, String database_name) {
        if (Strings.isEmpty((String)host_name) || Strings.isEmpty((String)database_name)) {
            return "";
        }
        if ("MySQL".equals(database_type)) {
            return "jdbc:mysql://" + host_name + "/" + database_name;
        }
        if ("PostgreSQL".equals(database_type)) {
            return "jdbc:postgresql://" + host_name + "/" + database_name;
        }
        return "";
    }

    private void renameJDOPackageFile(String dbtype, String folder) {
        dbtype = "MySQL".equals(dbtype) || "PostgreSQL".equals(dbtype) || Strings.isEmpty((String)dbtype) ? "mysql" : dbtype.toLowerCase();
        InputStream pckFile = ((Object)((Object)this)).getClass().getResourceAsStream(folder + "/package-" + dbtype + ".jdo");
        try {
            if (pckFile == null || pckFile.available() <= 0) {
                throw new IllegalArgumentException("Failed to locate package file " + folder + "/package-" + dbtype + ".jdo");
            }
            String dir = this.getServletContext().getRealPath("/") + "WEB-INF/classes" + folder;
            File currentDir = new File(dir);
            if (!currentDir.exists() && !currentDir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create folder " + folder);
            }
            File currentfile = new File(dir, "package.jdo");
            if (!currentfile.exists() && !currentfile.createNewFile()) {
                throw new IllegalArgumentException("Failed to create new package file " + folder + "/package.jdo");
            }
            try (FileOutputStream fos = new FileOutputStream(currentfile);){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = pckFile.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not copy " + folder + "/package.jdo file: " + e.getMessage());
        }
        finally {
            if (pckFile != null) {
                try {
                    pckFile.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to close package file", (Throwable)ex);
                }
            }
        }
    }

    private void executeSQL(Connection con, String sqlstring) throws SQLException {
        this.executeSQL(con, sqlstring, null);
    }

    private void executeSQL(Connection con, String sqlstring, String password) throws SQLException {
        try (Statement s = con.createStatement();){
            int i;
            Object logstring = sqlstring;
            if (password != null && (i = ((String)logstring).indexOf(password)) != -1) {
                logstring = ((String)logstring).substring(0, i) + "[password removed]" + ((String)logstring).substring(i + password.length());
            }
            LOGGER.info("Executing: {}", logstring);
            int rows = s.executeUpdate(sqlstring);
            LOGGER.info("Rows Updated: {}", (Object)rows);
        }
    }

    public static boolean createAdmin(String adminFirstname, String adminSurname, String adminUsername, String adminEmail, String adminPassword, Database db, Transaction tr, HttpServletRequest req) throws IOException {
        boolean login_required = true;
        try {
            Collection mfgi;
            Group grp;
            String host_name;
            Host host;
            Group pub = DatabaseQuery.getGroupByName((Database)db, (String)"public");
            if (pub == null) {
                pub = Group.create((Database)db);
                pub.setName("public");
                pub.setDescription("Public access to documents");
                pub.insert(db);
            }
            if ((host = DatabaseQuery.getHostByName((Database)db, (String)(host_name = HostRule.resolveAlias((Database)db, (String)GlobalSettings.get((String)"webSiteAddress"))))) == null) {
                host = Host.create((Database)db);
                host.setName(host_name);
                host.insert(db);
                MailHosts.clearInternalHosts();
            }
            if ((grp = DatabaseQuery.getGroupByName((Database)db, (String)"admin")) == null) {
                grp = Group.create((Database)db);
                grp.setName("admin");
                grp.setDescription("PageSeeder Administrators");
                grp = grp.insert(db);
            }
            if ((mfgi = DatabaseQuery.getMemberForGroupsByGroupId((Database)db, (Long)grp.getId())).isEmpty()) {
                Member mem = Member.create((Database)db);
                Date now = new Date();
                mem.setCreated(now);
                mem.setActivated(now);
                mem.setFirstName(adminFirstname);
                mem.setSurname(adminSurname);
                mem.setEmail(adminEmail);
                String username = adminUsername == null || adminUsername.length() == 0 ? adminEmail : adminUsername;
                mem.setUsername(username);
                mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)adminPassword));
                mem = mem.insert(db);
                MemberForGroup mfg = MemberForGroup.create((Database)db);
                mfg.setListed(Boolean.TRUE);
                mfg.setNotification("None");
                mfg.setMember(mem);
                mfg.setEditor(Boolean.TRUE);
                grp.addMembersForGroup(mfg);
                mfg.insert(db);
                tr.commit();
                SecurityUtils.login((Database)db, (String)username, (HttpServletRequest)req);
                login_required = false;
            }
        }
        catch (FoundationException | DatabaseException ex) {
            throw new IOException("Failed to create administrator: " + ex.getMessage(), ex);
        }
        return login_required;
    }

    private void sendError(HttpServletRequest req, HttpServletResponse res, String message, Throwable throwable) throws IOException {
        LOGGER.error(message, throwable);
        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)FrameworkErrorID.UNSPECIFIED, (String)(message + ": " + throwable.getMessage()));
    }

    private String getParameterLegacy(HttpServletRequest req, String name, String legacy) {
        String res = req.getParameter(name);
        if (res == null) {
            res = req.getParameter(legacy);
        }
        return res;
    }

    public String getServletInfo() {
        return "Handles PageSeeder configuration setup.";
    }
}

