/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Role;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public final class ImportMembers
extends HttpServlet {
    private static final long serialVersionUID = -1398130869312462848L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportMembers.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if (WebUtilities.deprecatedError((HttpServletRequest)req, (HttpServletResponse)res, (String)"")) {
            return;
        }
        WebRequest wr = new WebRequest(req, res);
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminSystemCheck(req))) {
                tr.abort();
                return;
            }
            String groupname = wr.getParameter("group", "");
            Group group = "".equals(groupname) ? null : DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            res.setContentType("application/xml");
            res.setCharacterEncoding("UTF-8");
            XMLWriterImpl xml = new XMLWriterImpl((Writer)res.getWriter());
            xml.openElement("root", true);
            if (group != null) {
                xml.openElement("group", true);
                xml.element("name", group.getName());
                xml.element("flags", group.getFlags());
                xml.closeElement();
            }
            xml.closeElement();
            xml.flush();
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wr.sendError(500, "Failed to start transaction: " + ex.getMessage());
        }
        catch (DatabaseException ex) {
            tr.abort();
            wr.sendError(500, "Unknown error: " + ex.getMessage());
        }
        finally {
            db.close();
            db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if (WebUtilities.deprecatedError((HttpServletRequest)req, (HttpServletResponse)res, (String)"")) {
            return;
        }
        WebRequest wreq = new WebRequest(req, res);
        String data = req.getParameter("data");
        String group_name = wreq.getParameter("group", "");
        String notification = wreq.getParameter("notification", "immediate");
        String role = wreq.getParameter("role");
        boolean listed = wreq.getBooleanParameter("listed", false);
        boolean createPersonalGroup = wreq.getBooleanParameter("createpersonal", false);
        Database db = wreq.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminSystemCheck(req))) {
                tr.abort();
                return;
            }
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                wreq.sendError(419, "Missing correct CSRF token");
                tr.abort();
                return;
            }
            Group group = null;
            if (!"".equals(group_name) && ((group = DatabaseQuery.getGroupByName((Database)db, (String)group_name)) == null || "admin".equals(group_name) || "public".equals(group_name))) {
                wreq.sendError(400, "Invalid group name ");
                tr.abort();
                return;
            }
            Role psrole = Role.forAttribute((String)role);
            if (psrole == null) {
                psrole = Role.forTitle((String)role);
            }
            if (psrole == null && group != null) {
                psrole = group.hasFlag('t') ? Role.CONTRIBUTOR : Role.REVIEWER;
            } else if (psrole == Role.MODERATOR || psrole == Role.MODERATOR_AND_APPROVER) {
                wreq.sendError(400, "Role not supported");
                tr.abort();
                return;
            }
            Notification notify = Notification.forType((String)notification);
            if (notify == null) {
                notify = Notification.IMMEDIATE;
            }
            ArrayList<Members.MemberDetails> created = new ArrayList<Members.MemberDetails>();
            ArrayList<Members.MemberDetails> existing = new ArrayList<Members.MemberDetails>();
            ArrayList<Members.MemberDetails> failed = new ArrayList<Members.MemberDetails>();
            int totalread = Members.importMembers(db, tr, data, createPersonalGroup, group, psrole, notify, listed, created, existing, failed);
            res.setContentType("application/xml");
            res.setCharacterEncoding("UTF-8");
            XMLWriterImpl xml = new XMLWriterImpl((Writer)res.getWriter());
            xml.openElement("root", true);
            xml.openElement("group", true);
            xml.element("name", group.getName());
            xml.element("flags", group.getFlags());
            xml.closeElement();
            xml.element("totalread", Integer.toString(totalread));
            xml.openElement("created");
            for (Members.MemberDetails md : created) {
                md.toXML((XMLWriter)xml, "member");
            }
            xml.closeElement();
            xml.openElement("failed");
            for (Members.MemberDetails md : failed) {
                md.toXML((XMLWriter)xml, "memberdetails");
            }
            xml.closeElement();
            xml.openElement("existing");
            for (Members.MemberDetails md : existing) {
                md.toXML((XMLWriter)xml, "memberdetails");
            }
            xml.closeElement();
            xml.closeElement();
            xml.flush();
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wreq.sendError(500, "Failed to start transaction: " + ex.getMessage());
        }
        catch (Exception ex) {
            tr.abort();
            LOGGER.error("Unknown error: " + ex.getMessage(), (Throwable)ex);
            wreq.sendError(500, "Unknown error: " + ex.getMessage());
        }
        finally {
            db.close();
            db = null;
        }
    }

    public String getServletInfo() {
        return "Imports members from comma separated data.";
    }
}

