/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith;

import java.io.IOException;
import java.util.List;
import org.pageseeder.smith.PasswordConfig;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.Scriptable;

public final class PasswordMeter
implements Scriptable {
    private final PasswordConfig _config;

    public PasswordMeter() {
        this._config = PasswordConfig.defaultConfig();
    }

    public PasswordMeter(PasswordConfig config) {
        if (config == null) {
            throw new NullPointerException("Config");
        }
        this._config = config;
    }

    public String getLevel(String password) {
        int score = this.score(password);
        return this._config.getLevel(score);
    }

    public int[] vector(String password) {
        int[] vector = new int[this._config.rules().size()];
        int i = 0;
        for (PasswordRule rule : this._config.rules()) {
            vector[i++] = rule.score(password);
        }
        return vector;
    }

    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int score = 0;
        for (int s : this.vector(password)) {
            score += s;
        }
        return score;
    }

    public boolean isAtLeast(String password, String level) {
        int threshold = this._config.getThreshold(level);
        int score = this.score(password);
        return score >= threshold;
    }

    public PasswordConfig configuration() {
        return this._config;
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("var SMITH = {};");
        script.append("(function () {");
        script.append(" var score = function score(p) {");
        script.append(" var rules = [];");
        for (PasswordRule rule : this._config.rules()) {
            script.append(" rules.push(");
            rule.toScript(script).append(");\n");
        }
        script.append(" var s = 0;");
        script.append(" for (var i=0; i < rules.length; i++) { s += rules[i](p); }");
        script.append(" return s;");
        script.append(" };");
        script.append(" var level = function level(s) {");
        List<String> levels = this._config.levels();
        for (int i = levels.size() - 1; i >= 0; --i) {
            String level = levels.get(i);
            if (i > 0) {
                int threshold = this._config.getThreshold(level);
                script.append(" if (s >= ").append(Integer.toString(threshold)).append(") { return '").append(level).append("';}");
                continue;
            }
            script.append(" return '").append(level).append("';");
        }
        script.append(" };");
        script.append(" var get = function get(p) {");
        script.append(" var s = score(p);");
        script.append(" var l = level(s);");
        script.append(" return {score: s, level: l};");
        script.append(" };");
        script.append(" SMITH.score = score;");
        script.append(" SMITH.level = level;");
        script.append(" SMITH.get = get;");
        String version = Package.getPackage("org.pageseeder.smith").getImplementationVersion();
        script.append(" SMITH.version = '").append(version != null ? version : "unspecified").append("';");
        script.append("})();");
        return script;
    }

    public static void main(String[] args) throws IOException {
        PasswordMeter meter = new PasswordMeter();
        if (args.length == 0) {
            System.err.println("PasswordMeter [password]");
        }
        if (args.length > 0) {
            String password = args[0];
            int score = meter.score(password);
            String level = meter.configuration().getLevel(score);
            System.out.println(password + " -> " + level + " (" + score + ")");
            for (PasswordRule rule : meter.configuration().rules()) {
                System.out.println(rule.getClass().getSimpleName() + "=" + rule.score(password));
            }
        } else {
            meter.toScript(System.out);
        }
    }
}

