/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.utils;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.utils.PSHighlighter;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.flint.lucene.util.Highlighter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Results {
    private static final Logger LOGGER = LoggerFactory.getLogger(Results.class);
    private static final int ONE_HOUR_IN_MS = 3600000;
    private static final int EXTRACT_LENGTH = 200;
    private static final int MAX_FIELD_LENGTH_FOR_EXTRACT = 1000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(SearchResults results, SearchPaging paging, Collection<String> extractFields, int maxFieldSize, Catalog catalog, Analyzer analyser, Collection<Group> groups, OutputPrinter out) {
        out.startObject("results");
        int totalResults = results.getTotalNbOfResults();
        int firsthit = paging.getFirstHit();
        int lasthit = paging.getLastHit(totalResults);
        out.field("page", (long)paging.getPage());
        out.field("page-size", (long)paging.getHitsPerPage());
        out.field("total-pages", (long)paging.getPageCount(totalResults));
        out.field("total-results", (long)totalResults);
        if (totalResults > 0) {
            out.field("first-result", (long)firsthit);
            out.field("last-result", (long)lasthit);
        }
        try {
            ResultsHighlighter highlighter = extractFields == null || extractFields.isEmpty() ? null : new ResultsHighlighter(results, analyser, extractFields);
            ScoreDoc[] scoredocs = results.getScoreDoc();
            out.startCollection("result", OutputPrinter.CollectionOption.JSON_ONLY);
            for (int i = firsthit - 1; i < lasthit; ++i) {
                float score = scoredocs[i].score;
                Document doc = results.getDocument(scoredocs[i].doc);
                Results.print(doc, score, highlighter, analyser, maxFieldSize, catalog, groups, out);
            }
            out.endCollection();
        }
        catch (IndexException indexException) {
        }
        finally {
            out.endObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(Document doc, float score, ResultsHighlighter highlighter, Analyzer analyser, int maxFieldSize, Catalog catalog, Collection<Group> groups, OutputPrinter out) {
        out.startObject("result");
        if (!Float.isNaN(score)) {
            out.field("score", Float.toString(score));
        }
        try {
            boolean isURL = "url".equals(doc.get("pstype"));
            if (highlighter != null) {
                highlighter.printExtract(doc, out);
            }
            out.startCollection("fields", OutputPrinter.CollectionOption.JSON_ONLY);
            for (IndexableField f : doc.getFields()) {
                if (IndexAnalyzers.isAnalyzerPrefixField(analyser, f.name())) continue;
                String value = Fields.toString((IndexableField)f);
                if (isURL && value != null && groups != null && ("psgroupname".equals(f.name()) || "psgroupid".equals(f.name()))) {
                    boolean checkName = "psgroupname".equals(f.name());
                    boolean found = false;
                    for (Group gp : groups) {
                        if ((!checkName || !value.equals(gp.getName())) && (checkName || !value.equals(gp.getId().toString()))) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                String type = null;
                String asDate = null;
                Number number = f.numericValue();
                if (number != null) {
                    if (number instanceof Long) {
                        type = "long";
                    } else if (number instanceof Double) {
                        type = "double";
                    } else if (number instanceof Integer) {
                        type = "int";
                    } else if (number instanceof Float) {
                        type = "float";
                    }
                } else if (!Strings.isEmpty((String)value) && catalog != null && catalog.getResolution(f.name()) != null) {
                    try {
                        if (value.length() > 8) {
                            asDate = Dates.toISODateTime((String)value, (int)Results.getTimezoneOffset());
                            type = "datetime";
                        } else {
                            asDate = Dates.toISODate((String)value);
                            if (asDate.length() == 10) {
                                type = "date";
                            }
                        }
                    }
                    catch (ParseException ex) {
                        LOGGER.warn("Unparseable date found {} in index", (Object)value);
                    }
                }
                if (value == null || value.length() >= maxFieldSize) continue;
                out.startObject("field");
                out.field("name", f.name());
                if ("date".equals(type)) {
                    out.field("date", asDate);
                } else if ("datetime".equals(type)) {
                    out.field("datetime", asDate);
                } else if (type != null) {
                    out.field("numeric-type", type);
                }
                if (f.binaryValue() != null) {
                    out.field("compressed", true);
                }
                out.field("value", value, OutputPrinter.FieldOption.XML_TEXT);
                out.endObject();
            }
            out.endCollection();
        }
        finally {
            out.endObject();
        }
    }

    private static int getTimezoneOffset() {
        TimeZone tz = TimeZone.getDefault();
        int timezoneOffset = tz.getRawOffset();
        if (tz.inDaylightTime(new Date())) {
            timezoneOffset += 3600000;
        }
        return timezoneOffset;
    }

    private static class ResultsHighlighter {
        private final IndexSearcher searcher;
        private final SearchQuery query;
        private final Highlighter highlighter;
        private final Collection<String> extractFields;
        private PSHighlighter fallback = null;

        ResultsHighlighter(SearchResults results, Analyzer analyzer, Collection<String> extractfields) throws IndexException {
            this.searcher = results.searcher();
            this.query = results.query();
            this.extractFields = extractfields;
            this.highlighter = new Highlighter(this.query.toQuery(), analyzer);
            this.highlighter.setMarkerTag("term");
        }

        void printExtract(Document doc, OutputPrinter out) {
            try {
                for (String field : this.extractFields) {
                    IndexableField[] fields;
                    for (IndexableField f : fields = doc.getFields(field)) {
                        String extract;
                        String value;
                        String string = value = f == null ? null : Fields.toString((IndexableField)f);
                        if (value == null) continue;
                        if (value.length() >= 1000000) {
                            value = value.substring(0, 1000000);
                        }
                        if ((extract = this.highlighter.highlight(field, value, 200)) == null) continue;
                        out.startObject("extract");
                        out.field("name", field);
                        out.field("extract", extract, OutputPrinter.FieldOption.XML_COPY);
                        out.endObject();
                        return;
                    }
                }
            }
            catch (IndexSearcher.TooManyClauses ex) {
                if (this.fallback == null) {
                    this.fallback = new PSHighlighter(this.searcher, this.query, this.extractFields);
                }
                this.fallback.extract(doc, out);
            }
        }
    }
}

