/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.common.util.GenericBuilder;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.Ranges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.pageseeder.flint.lucene.query.AnyTermParameter;
import org.pageseeder.flint.lucene.query.FacetParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Facet;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericQuery
implements SearchQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericQuery.class);
    private final Question _question;
    private final AnyTermParameter _types;
    private final List<FacetParameter> _facets;
    private final List<Ranges.Range> _ranges;
    private final Sort _sort;
    private final Query _query;

    private GenericQuery(Question question, AnyTermParameter types, List<FacetParameter> facets, List<Ranges.Range> ranges, Sort sort) {
        if (question == null) {
            throw new NullPointerException("question");
        }
        if (types == null) {
            throw new NullPointerException("types");
        }
        if (facets == null) {
            throw new NullPointerException("facets");
        }
        if (sort == null) {
            throw new NullPointerException("sort");
        }
        this._question = question;
        this._types = types;
        this._facets = facets;
        this._sort = sort;
        this._ranges = ranges;
        this._query = GenericQuery.toQuery(question, types, facets, ranges);
    }

    public Question question() {
        return this._question;
    }

    public Sort getSort() {
        return this._sort;
    }

    public boolean isEmpty() {
        return this._query == null;
    }

    public Query toQuery() {
        return this._query;
    }

    public GenericQuery newGenericQuery(Question question) {
        return new GenericQuery(question, this._types, this._facets, this._ranges, this._sort);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("generic-query", true);
        xml.attribute("empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.attribute("query", this._query.toString());
            if (this._question != null) {
                this._question.toXML(xml);
            }
            if (this._types != null) {
                this._types.toXML(xml);
            }
            for (FacetParameter f : this._facets) {
                f.toXML(xml);
            }
            Ranges.toXML(this._ranges, xml);
            xml.openElement("sort", this._sort != Sort.RELEVANCE);
            if (this._sort == Sort.RELEVANCE) {
                xml.attribute("by", "relevance");
            } else {
                xml.attribute("by", "fields");
                for (SortField sf : this._sort.getSort()) {
                    xml.openElement("sortfield");
                    xml.attribute("field", sf.getField());
                    xml.attribute("type", sf.getType().name());
                    xml.attribute("reverse", Boolean.toString(sf.getReverse()));
                    xml.closeElement();
                }
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private static Query toQuery(Question question, AnyTermParameter types, List<FacetParameter> facets, List<Ranges.Range> ranges) {
        Query query = null;
        if (!question.isEmpty()) {
            query = question.toQuery();
        }
        if (!types.isEmpty()) {
            Query hasType = types.toQuery();
            Query query2 = query = query != null ? Queries.and((Query[])new Query[]{query, hasType}) : hasType;
        }
        if (!facets.isEmpty() || ranges != null && !ranges.isEmpty()) {
            BooleanQuery.Builder fq = new BooleanQuery.Builder();
            for (FacetParameter f : facets) {
                fq.add(f.toQuery(), BooleanClause.Occur.MUST);
            }
            if (ranges != null && !ranges.isEmpty()) {
                for (Ranges.Range range : ranges) {
                    fq.add(range.toParameter().toQuery(), BooleanClause.Occur.MUST);
                }
            }
            query = query != null ? Queries.and((Query[])new Query[]{query, fq.build()}) : fq.build();
        }
        return query;
    }

    public static final class Builder
    implements GenericBuilder<GenericQuery> {
        protected static final String TYPE_FIELD = "pstype";
        public static final String LASTMODIFIED_FIELD = "psmodifieddate";
        protected static final String SIZE_FIELD = "pssize";
        private String _question = null;
        private final List<Ranges.Range> _ranges = new ArrayList<Ranges.Range>();
        private final List<Term> _types = new ArrayList<Term>();
        private final List<String> _fields = new ArrayList<String>();
        private List<FacetParameter> _facets = null;
        private Group _group;
        private Database _db;
        private List<SortField> _sort = null;
        private Date _from = null;
        private Date _to = null;
        private Integer _minSize = null;
        private Integer _maxSize = null;

        public Builder question(String question) {
            this._question = question;
            return this;
        }

        public Builder addRange(Ranges.Range range) {
            if (range != null) {
                this._ranges.add(range);
            }
            return this;
        }

        public Builder addType(String type) {
            if (type != null && type.length() > 0) {
                Term t = new Term(TYPE_FIELD, type);
                this._types.add(t);
            } else {
                LOGGER.info("Attempted to add empty type - ignored");
            }
            return this;
        }

        public Builder from(Date from) {
            this._from = from;
            return this;
        }

        public Builder to(Date to) {
            this._to = to;
            return this;
        }

        public Builder minSize(Integer min) {
            this._minSize = min;
            return this;
        }

        public Builder maxSize(Integer max) {
            this._maxSize = max;
            return this;
        }

        public Builder addSetSortField(String field, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add((SortField)new SortedSetSortField(field, reverse));
            }
            return this;
        }

        public Builder addSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add(new SortField(field, type, reverse));
            }
            return this;
        }

        public Builder addNumericSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add((SortField)new SortedNumericSortField(field, type, reverse));
            }
            return this;
        }

        public Builder addSearchField(String field) {
            this._fields.add(field);
            return this;
        }

        public Builder addFieldFacet(Facet facet, String value) {
            FacetParameter fp;
            if (this._facets == null) {
                this._facets = new ArrayList<FacetParameter>();
            }
            if (!(fp = new FacetParameter(facet, value)).isEmpty()) {
                this._facets.add(fp);
            }
            return this;
        }

        public void resetFieldFacets() {
            if (this._facets != null) {
                this._facets.clear();
            }
        }

        public Builder group(Group group) {
            this._group = group;
            return this;
        }

        public Builder database(Database db) {
            this._db = db;
            return this;
        }

        public GenericQuery build() {
            IndexMaster master = IndexMaster.getInstance();
            String q = this._question != null ? this._question : "";
            LOGGER.debug("Parsing question: {}", (Object)q);
            Question question = master.newQuestion(this._db, this._group, this._fields, q);
            AnyTermParameter types = this._types.size() > 0 ? new AnyTermParameter(this._types) : AnyTermParameter.empty();
            List<Object> facets = this._facets != null && !this._facets.isEmpty() ? Collections.unmodifiableList(new ArrayList<FacetParameter>(this._facets)) : Collections.emptyList();
            Sort sort = Sort.RELEVANCE;
            if (this._sort != null && !this._sort.isEmpty()) {
                sort = new Sort(this._sort.toArray(new SortField[this._sort.size()]));
            }
            if (this._from != null || this._to != null) {
                this._ranges.add(new Ranges.DateRange(LASTMODIFIED_FIELD, this._from, this._to, true, true, false, DateTools.Resolution.MINUTE));
                this._from = null;
                this._to = null;
            }
            if (this._minSize != null || this._maxSize != null) {
                this._ranges.add(new Ranges.NumberRange(SIZE_FIELD, this._minSize, this._maxSize, true, true));
                this._minSize = null;
                this._maxSize = null;
            }
            List<Ranges.Range> ranges = this._ranges != null && !this._ranges.isEmpty() ? Collections.unmodifiableList(new ArrayList<Ranges.Range>(this._ranges)) : Collections.emptyList();
            return new GenericQuery(question, types, facets, ranges, sort);
        }
    }
}

