/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.db.model.Group;
import java.text.ParseException;
import java.util.Collection;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.facet.DateFieldFacet;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.util.Bucket;
import org.slf4j.LoggerFactory;

public class Facets {
    public static void printFlexibleField(FlexibleFieldFacet facet, Collection<Group> groups, Catalog catalog, OutputPrinter out) {
        String field = facet.name();
        boolean filterGroup = groups != null && ("psgroupname".equals(field) || "psgroupid".equals(field));
        out.startObject("facet");
        out.field("name", field);
        out.field("type", facet.getType());
        out.field("flexible", facet.isFlexible());
        Facets.printDataType(field, catalog, out);
        int totalTerms = facet.getTotalTerms();
        if (totalTerms == -1) {
            out.field("has-results", facet.hasResults());
        } else {
            out.field("has-results", totalTerms > 0);
            out.field("total-terms", (long)totalTerms);
        }
        Bucket values = facet.getValues();
        if (values != null) {
            out.startCollection("terms", OutputPrinter.CollectionOption.JSON_ONLY);
            DateFieldFacet dateFacet = facet instanceof DateFieldFacet ? (DateFieldFacet)facet : null;
            for (Bucket.Entry e : values.entrySet()) {
                String value = (String)e.item();
                if (filterGroup) {
                    boolean checkName = "psgroupname".equals(field);
                    boolean found = false;
                    for (Group gp : groups) {
                        if ((!checkName || !value.equals(gp.getName())) && (checkName || !value.equals(gp.getId().toString()))) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                out.startObject("term");
                out.field("text", value);
                out.field("cardinality", (long)e.count());
                if (dateFacet != null && value.length() > 0) {
                    try {
                        out.field("date", dateFacet.toISODateString(value));
                    }
                    catch (ParseException ex) {
                        LoggerFactory.getLogger(Facets.class).warn("Invalid date {} in index", (Object)value, (Object)ex);
                        out.field("date", value);
                        out.field("invalid", "true");
                    }
                }
                out.endObject();
            }
            out.endCollection();
        }
        out.endObject();
    }

    public static void printFlexibleRange(FlexibleRangeFacet facet, Catalog catalog, OutputPrinter out) {
        Bucket values;
        out.startObject("facet");
        out.field("name", facet.name());
        out.field("type", facet.getType());
        out.field("flexible", facet.isFlexible());
        Facets.printDataType(facet.name(), catalog, out);
        if (!facet.isFlexible()) {
            out.field("total-ranges", (long)facet.getTotalRanges());
        }
        if ((values = facet.getValues()) != null) {
            out.startCollection("ranges", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Bucket.Entry e : values.entrySet()) {
                if (FlexibleRangeFacet.isOther((FlexibleRangeFacet.Range)((FlexibleRangeFacet.Range)e.item()))) {
                    out.startObject("remaining-range");
                    out.field("cardinality", (long)e.count());
                    out.endObject();
                    continue;
                }
                FlexibleRangeFacet.Range range = (FlexibleRangeFacet.Range)e.item();
                out.startObject("range");
                if (range.getMin() != null) {
                    out.field("min", range.getFormattedMin());
                }
                if (range.getMax() != null) {
                    out.field("max", range.getFormattedMax());
                }
                if (range.getMin() != null) {
                    out.field("include-min", range.includeMin());
                }
                if (range.getMax() != null) {
                    out.field("include-max", range.includeMax());
                }
                out.field("cardinality", (long)e.count());
                out.endObject();
            }
            out.endCollection();
        }
        out.endObject();
    }

    public static void printFlexibleInterval(FlexibleIntervalFacet facet, Catalog catalog, OutputPrinter out) {
        Bucket values;
        out.startObject("facet");
        out.field("name", facet.name());
        out.field("start", facet.formattedStart());
        if (facet.end() != null) {
            out.field("end", facet.formattedEnd());
        }
        out.field("type", facet.getType());
        out.field("flexible", facet.isFlexible());
        Facets.printDataType(facet.name(), catalog, out);
        if (!facet.isFlexible()) {
            out.field("total-intervals", (long)facet.getTotalIntervals());
        }
        if ((values = facet.getValues()) != null) {
            out.startCollection("intervals", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Bucket.Entry e : values.entrySet()) {
                FlexibleIntervalFacet.Interval interval = (FlexibleIntervalFacet.Interval)e.item();
                out.startObject("interval");
                if (interval.getMin() != null) {
                    out.field("min", interval.getFormattedMin());
                }
                if (interval.getMax() != null) {
                    out.field("max", interval.getFormattedMax());
                }
                if (interval.getMin() != null) {
                    out.field("include-min", interval.includeMin());
                }
                if (interval.getMax() != null) {
                    out.field("include-max", interval.includeMax());
                }
                out.field("cardinality", (long)e.count());
                out.endObject();
            }
            out.endCollection();
        }
        out.endObject();
    }

    private static void printDataType(String field, Catalog catalog, OutputPrinter out) {
        String datatype = "string";
        if (catalog != null) {
            if (catalog.getDateFormat(field) != null) {
                FlintField.Resolution res = catalog.getResolution(field);
                boolean isDate = res == FlintField.Resolution.DAY || res == FlintField.Resolution.MONTH || res == FlintField.Resolution.YEAR;
                datatype = isDate ? "date" : "datetime";
            } else if (catalog.getNumericType(field) != null) {
                datatype = "number";
            }
        }
        out.field("datatype", datatype);
    }
}

