/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AutoSuggestQuery
implements SearchQuery {
    private final Analyzer analyzer;
    private final String input;
    private boolean prefixLastTermOnly = true;
    private boolean unionTermResults = false;
    private final List<String> fields;
    private final Query condition;
    private Query query = null;
    private boolean tooManyPrefixes = false;

    public AutoSuggestQuery(String input, List<String> fields, Analyzer analyzer, Query condition) {
        this.input = input;
        this.fields = fields;
        this.analyzer = analyzer;
        this.condition = condition;
    }

    public void setPrefixLastTermOnly(boolean prefixLastTermOnly) {
        this.prefixLastTermOnly = prefixLastTermOnly;
    }

    public void setUnionTermResults(boolean unionTermResults) {
        this.unionTermResults = unionTermResults;
    }

    public void compute(IndexReader reader) throws IOException {
        BooleanQuery mainQuery = this.computeQuery(reader);
        if (this.condition == null) {
            this.query = mainQuery;
        } else {
            BooleanQuery.Builder dad = new BooleanQuery.Builder();
            SearchUtils.addMustClause(dad, this.condition);
            dad.add((Query)mainQuery, BooleanClause.Occur.MUST);
            this.query = dad.build();
        }
    }

    public boolean isIncomplete() {
        return this.tooManyPrefixes;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("suggestion-query");
        xml.attribute("input", this.input);
        if (this.tooManyPrefixes) {
            xml.attribute("incomplete", "true");
        }
        xml.attribute("fields", String.join((CharSequence)",", this.fields));
        if (this.condition != null) {
            xml.openElement("condition");
            xml.writeText(this.condition.toString());
            xml.closeElement();
        }
        xml.closeElement();
    }

    public Query toQuery() {
        return this.query;
    }

    public boolean isEmpty() {
        return this.input.isEmpty() || this.fields.isEmpty();
    }

    public Sort getSort() {
        return Sort.RELEVANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BooleanQuery computeQuery(IndexReader reader) throws IOException {
        BooleanQuery.Builder builder;
        block16: {
            int maxPrefixes = GlobalSettings.getInt((String)"maxAutosuggestPrefixes", (int)800);
            int totalPrefixes = 0;
            builder = new BooleanQuery.Builder();
            BooleanQuery.Builder fieldQuery = null;
            BooleanQuery.Builder prefixesQuery = null;
            List values = null;
            try {
                Analyzer clonedWithStopWords = IndexAnalyzers.cloneAnalyzerKeepStopwords(this.analyzer);
                for (String field : this.fields) {
                    boolean checkStopWords = IndexAnalyzers.isAnalyzerTokenizingField(this.analyzer, field) && IndexAnalyzers.isAnalyzerRemovingStopWordsField(this.analyzer, field);
                    List words = Fields.toTerms((String)field, (String)this.input, (Analyzer)(checkStopWords ? clonedWithStopWords : this.analyzer));
                    block6: for (int i = 0; i < words.size(); ++i) {
                        boolean shouldBeRemoved;
                        String word = (String)words.get(i);
                        boolean lastOne = i == words.size() - 1;
                        boolean bl = shouldBeRemoved = checkStopWords && EnglishAnalyzer.ENGLISH_STOP_WORDS_SET.contains((CharSequence)word) && !lastOne;
                        if (shouldBeRemoved) continue;
                        if (fieldQuery == null) {
                            fieldQuery = new BooleanQuery.Builder();
                        }
                        Term term = new Term(field, word);
                        if (this.prefixLastTermOnly && !lastOne) {
                            fieldQuery.add((Query)new TermQuery(term), this.unionTermResults ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
                            ++totalPrefixes;
                            continue;
                        }
                        prefixesQuery = new BooleanQuery.Builder();
                        values = Terms.prefix((IndexReader)reader, (Term)term);
                        try {
                            for (String v : values) {
                                this.addTermQuery(term, v, prefixesQuery);
                                if (++totalPrefixes < maxPrefixes) break block14;
                                if (values.isEmpty()) break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!values.isEmpty()) {
                                fieldQuery.add((Query)prefixesQuery.build(), this.unionTermResults ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
                            }
                            values = null;
                            prefixesQuery = null;
                            throw throwable;
                        }
                        {
                            block14: {
                                block15: {
                                    fieldQuery.add((Query)prefixesQuery.build(), this.unionTermResults ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
                                }
                                values = null;
                                prefixesQuery = null;
                                break block6;
                            }
                            continue;
                        }
                        if (!values.isEmpty()) {
                            fieldQuery.add((Query)prefixesQuery.build(), this.unionTermResults ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
                        }
                        values = null;
                        prefixesQuery = null;
                    }
                    if (fieldQuery != null && fieldQuery.build().iterator().hasNext()) {
                        builder.add((Query)fieldQuery.build(), BooleanClause.Occur.SHOULD);
                    }
                    fieldQuery = null;
                }
            }
            catch (IndexSearcher.TooManyClauses ex) {
                this.tooManyPrefixes = true;
                if (fieldQuery != null && prefixesQuery != null && values != null && !values.isEmpty()) {
                    fieldQuery.add((Query)prefixesQuery.build(), this.unionTermResults ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
                }
                if (fieldQuery == null || !fieldQuery.build().iterator().hasNext()) break block16;
                builder.add((Query)fieldQuery.build(), BooleanClause.Occur.SHOULD);
            }
        }
        return builder.build();
    }

    private void addTermQuery(Term original, String value, BooleanQuery.Builder query) throws IndexSearcher.TooManyClauses {
        if (value.equals(original.text())) {
            query.add((Query)new BoostQuery((Query)new TermQuery(original), 2.0f), BooleanClause.Occur.SHOULD);
        } else {
            query.add((Query)new TermQuery(new Term(original.field(), value)), BooleanClause.Occur.SHOULD);
        }
    }
}

