/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.help;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.help.HelpIndex;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.queries.Ranges;
import com.pageseeder.search.utils.Results;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.MultipleIndexReader;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Output(types={OutputType.XML, OutputType.JSON})
public final class SearchHelpIndex
implements Generator,
SingleCheck,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchHelpIndex.class);
    private static final int DEFAULT_MAX_RESULTS = 100;
    private static final int DEFAULT_FIELD_SIZE = 1000;
    private static final int MAX_FIELD_SIZE = 10000;
    private static final int DEFAULT_MAX_SUGGESTIONS = 20;
    private static final List<String> DEFAULT_CSV_COLUMNS = Arrays.asList("psid", "pstitle", "psmodifieddate");

    public String getETag(GeneratorRequest req) {
        StringBuilder etag = new StringBuilder();
        etag.append(",question:").append(req.getParameter((Parameter)StandardParameters.question, ""));
        etag.append(",questionoperator:").append(req.getParameter((Parameter)StandardParameters.questionoperator, "OR"));
        etag.append(",questionfields:").append(req.getParameter((Parameter)StandardParameters.questionfields, ""));
        etag.append(",filters:").append(req.getParameter((Parameter)StandardParameters.filters, ""));
        etag.append(",ranges:").append(req.getParameter((Parameter)StandardParameters.ranges, ""));
        etag.append(",predicate:").append(req.getParameter((Parameter)StandardParameters.predicate, "*"));
        etag.append(",defaultfield:").append(req.getParameter((Parameter)StandardParameters.defaultfield, "pscontent"));
        etag.append(",suggestsize:").append(req.getParameter((Parameter)StandardParameters.suggestsize, ""));
        etag.append(",page:").append(req.getParameter((Parameter)StandardParameters.page, 1L));
        etag.append(",pagesize:").append(req.getParameter((Parameter)StandardParameters.pagesize, 100L));
        etag.append(",fieldsize:").append(req.getParameter((Parameter)StandardParameters.fieldsize, 1000L));
        List<Index> indexes = SearchHelpIndex.loadIndexes(req);
        if (indexes != null) {
            for (Index index : indexes) {
                etag.append(',').append(index.getIndexID()).append(':').append(index.getIndexIO().getLastTimeUsed());
            }
        }
        return etag.toString();
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        SearchResults results;
        PageSeederQuery query;
        Analyzer analyser;
        List<Index> indexes = SearchHelpIndex.loadIndexes(req);
        if (indexes == null) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load help indexes!");
            return;
        }
        if (indexes.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.MISSING_INDEX);
            return;
        }
        Catalog catalog = Catalogs.getCatalog((String)"help");
        try {
            analyser = IndexAnalyzers.getAnalyzer("default");
        }
        catch (SAXException ex) {
            LOGGER.error("Failed to create help analyser", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create help analyser: " + ex.getMessage());
            return;
        }
        if (catalog == null) {
            catalog = SearchUtils.getGlobalCatalog();
        }
        if (analyser == null) {
            try {
                analyser = IndexAnalyzers.getAnalyzer(null);
            }
            catch (IOException | SAXException ex) {
                LOGGER.error("Failed to create global analyser", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create global analyser: " + ex.getMessage());
                return;
            }
        }
        PageSeederQuery.Builder queryBuilder = new PageSeederQuery.Builder().analyser(IndexAnalyzers.cloneAnalyzerForQuery(analyser)).catalog(catalog).addStringFilter("psdocumenttype", "help", BooleanClause.Occur.MUST);
        String question = req.getParameter((Parameter)StandardParameters.question, "");
        String predicate = req.getParameter((Parameter)StandardParameters.predicate, "*");
        boolean predicateType = "predicate".equals(req.getParameter((Parameter)StandardParameters.type, "predicate"));
        if (predicateType) {
            String defaultField = req.getParameter((Parameter)StandardParameters.defaultfield, "pscontent");
            queryBuilder.predicate(predicate).defaultField(defaultField);
        } else {
            String[] rangesParam;
            String[] filtersParam;
            String[] questionfields;
            queryBuilder.question(question).questionDefaultOperatorOR("OR".equalsIgnoreCase(req.getParameter((Parameter)StandardParameters.questionoperator, "AND")));
            for (String qf : questionfields = Strings.split((String)req.getParameter((Parameter)StandardParameters.questionfields, "pstitle,pscontent"), (char)',')) {
                queryBuilder.addSearchField(qf);
            }
            for (String filter : filtersParam = Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\')) {
                if (filter.isEmpty()) continue;
                SearchUtils.addFilter(filter, catalog, queryBuilder);
            }
            for (String range : rangesParam = Strings.split((String)req.getParameter((Parameter)StandardParameters.ranges, ""), (char)',', (char)'\\')) {
                if (range.isEmpty()) continue;
                queryBuilder.addRange(Ranges.createRange(range, catalog));
            }
            String pageid = req.getParameter((Parameter)StandardParameters.pageid);
            String documentType = req.getParameter((Parameter)StandardParameters.document_type);
            if (pageid != null && documentType != null) {
                BooleanQuery.Builder filter = new BooleanQuery.Builder();
                filter.add((Query)new TermQuery(new Term("psmetadata-page_id", pageid)), BooleanClause.Occur.SHOULD);
                filter.add((Query)new TermQuery(new Term("psmetadata-document_type", documentType)), BooleanClause.Occur.SHOULD);
                queryBuilder.customFilter((Query)filter.build(), true);
            } else if (pageid != null) {
                queryBuilder.addStringFilter("psmetadata-page_id", pageid, BooleanClause.Occur.SHOULD);
            } else if (documentType != null) {
                queryBuilder.addStringFilter("psmetadata-document_type", documentType, BooleanClause.Occur.SHOULD);
            }
        }
        if (!this.addSort(req, res, catalog, queryBuilder)) {
            return;
        }
        try {
            query = queryBuilder.build();
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_PREDICATE, "Invalid predicate " + predicate + ": " + ex.getMessage());
            return;
        }
        int page = SearchUtils.getIntParameter(req, StandardParameters.page, 1);
        int pageSize = SearchUtils.getIntParameter(req, StandardParameters.pagesize, 100);
        int max = GlobalSettings.getInt((String)"maxPageSize", (int)10000);
        if (pageSize > max) {
            pageSize = max;
        }
        SearchPaging paging = new SearchPaging(page, pageSize);
        try {
            results = LuceneIndexQueries.query(indexes, (SearchQuery)query, (SearchPaging)paging);
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to search index", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to run query " + query + ": " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("search");
        boolean reindexing = false;
        for (Index idx : indexes) {
            if (!(idx instanceof GroupIndex) || !GroupIndexReindexing.isReindexing(((GroupIndex)idx).getGroupID())) continue;
            reindexing = true;
            break;
        }
        if (reindexing) {
            out.field("reindexing", true);
        }
        out.field("indexes", indexes.stream().map(Index::getIndexID).collect(Collectors.joining(",")));
        try {
            if (OutputType.CSV != out.getType()) {
                query.print((OutputPrinter)out);
                if (!predicateType) {
                    this.computeSuggestions(SearchUtils.getIntParameter(req, StandardParameters.suggestsize, 20), indexes, query, (OutputPrinter)out);
                }
            }
            int fieldsize = Math.min(SearchUtils.getIntParameter(req, StandardParameters.fieldsize, 1000), 10000);
            Collection<String> extractFields = this.extractFields(query, results.searcher());
            Results.print(results, paging, extractFields, fieldsize, catalog, analyser, null, (OutputPrinter)out);
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to output search results", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to output search results: " + ex.getMessage());
        }
        finally {
            results.terminate();
            out.endObject();
            out.flush();
        }
    }

    protected boolean addSort(GeneratorRequest req, GeneratorResponse res, Catalog catalog, PageSeederQuery.Builder builder) {
        String[] sortby;
        for (String sf : sortby = Strings.split((String)req.getParameter((Parameter)StandardParameters.sortfields, ""), (char)',')) {
            boolean reverse;
            if (sf.isEmpty()) continue;
            boolean bl = reverse = sf.charAt(0) == '-';
            if (reverse) {
                sf = sf.substring(1);
            }
            if (catalog != null) {
                FlintField.DocValuesType dvt = catalog.getDocValuesType(sf);
                if (dvt == FlintField.DocValuesType.SORTED_NUMERIC) {
                    FlintField.NumericType num = catalog.getNumericType(sf);
                    if (num == FlintField.NumericType.INT) {
                        builder.addNumericSortField(sf, SortField.Type.INT, reverse);
                        continue;
                    }
                    if (num == FlintField.NumericType.LONG) {
                        builder.addNumericSortField(sf, SortField.Type.LONG, reverse);
                        continue;
                    }
                    if (num == FlintField.NumericType.FLOAT) {
                        builder.addNumericSortField(sf, SortField.Type.FLOAT, reverse);
                        continue;
                    }
                    if (num != FlintField.NumericType.DOUBLE) continue;
                    builder.addNumericSortField(sf, SortField.Type.DOUBLE, reverse);
                    continue;
                }
                if (dvt == FlintField.DocValuesType.SORTED_SET) {
                    builder.addSetSortField(sf, reverse);
                    continue;
                }
                if (dvt == FlintField.DocValuesType.SORTED) {
                    builder.addSortField(sf, SortField.Type.STRING, reverse);
                    continue;
                }
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SORT_FIELD, "Invalid sort field: " + sf);
                return false;
            }
            builder.addSortField(sf, SortField.Type.STRING, reverse);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSuggestions(int size, List<Index> indexes, PageSeederQuery query, OutputPrinter out) throws IOException {
        if (query.question() != null && !query.question().isEmpty()) {
            IndexMaster master = IndexMaster.getInstance();
            MultipleIndexReader multi = LuceneIndexQueries.getMultipleIndexReader(indexes);
            try {
                IndexSearcher searcher = new IndexSearcher(multi.grab());
                Bucket<Question> similar = master.similar(indexes, query.question(), size);
                if (similar != null && !similar.isEmpty()) {
                    out.startCollection("suggestions");
                    for (Question q : similar) {
                        out.startObject("suggestion");
                        out.field("question", q.question());
                        PageSeederQuery qq = query.newQuery(q);
                        if (qq != null) {
                            int count = Documents.count((IndexSearcher)searcher, (Query)qq.toQuery());
                            out.field("cardinality", (long)count);
                        }
                        out.endObject();
                    }
                    out.endCollection();
                }
            }
            catch (IndexException ex) {
                LOGGER.error("Failed to compute suggestions", (Throwable)ex);
            }
            finally {
                multi.releaseSilently();
            }
        }
    }

    private Collection<String> extractFields(PageSeederQuery query, IndexSearcher searcher) {
        if (query.question() != null) {
            return query.question().fields();
        }
        HashSet terms = new HashSet();
        try {
            query.toQuery().rewrite(searcher.getIndexReader()).visit(QueryVisitor.termCollector(terms));
        }
        catch (Exception ex) {
            LOGGER.warn("Computing extract failed, no extracts will be provided", (Throwable)ex);
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (Term t : terms) {
            if (fields.contains(t.field())) continue;
            fields.add(t.field());
        }
        return fields;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static List<Index> loadIndexes(GeneratorRequest req) {
        Database db = req.getDatabase();
        ArrayList<Index> indexes = new ArrayList<Index>();
        IndexMaster master = IndexMaster.getInstance();
        HelpIndex help = master.getHelpIndex();
        if (help != null) {
            indexes.add((Index)help);
        }
        try {
            Group globalHelp;
            String globalTemplate = GlobalSettings.getGlobalTemplate();
            if (globalTemplate != null && master.isIndexable(db, globalHelp = DatabaseQuery.getGroupByName((Database)db, (String)(globalTemplate + "-help")))) {
                indexes.add((Index)master.getIndex(db, globalHelp));
            }
            String contextProject = null;
            Group context = req.getGroup();
            if (context != null && GroupRule.isProject((Group)context)) {
                contextProject = context.getName();
            } else if (context != null) {
                contextProject = GroupRule.getParentProjectName((String)context.getName());
            }
            if (contextProject != null) {
                UserDetails details = new UserDetailsManager().get(db, req.getAuthenticatedMember().getId());
                while (contextProject.indexOf(45) > -1) {
                    SearchHelpIndex.addProjectIndex(indexes, contextProject, details, master, db);
                    contextProject = contextProject.replaceFirst("-[^-]+$", "");
                }
                SearchHelpIndex.addProjectIndex(indexes, contextProject, details, master, db);
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load help indexes", (Throwable)ex);
            return null;
        }
        return indexes;
    }

    private static void addProjectIndex(List<Index> indexes, String project, UserDetails details, IndexMaster master, Database db) throws QueryFailedException {
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (project != null && !project.equals(globalTemplate)) {
            if (details.getFlags(project) == null) {
                return;
            }
            Group contextHelp = DatabaseQuery.getGroupByName((Database)db, (String)(project + "-help"));
            if (master.isIndexable(db, contextHelp)) {
                indexes.add((Index)master.getIndex(db, contextHelp));
            }
        }
    }
}

