/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexMaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

@Requires(database=true, group=true)
public final class SaveSynonyms
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        File synonymsFile;
        String template = req.getGroup().getOwnerDirectory();
        Database db = req.getDatabase();
        String synonyms = req.getParameter((Parameter)StandardParameters.synonyms);
        if (synonyms != null) {
            HashMap<String, String> words = new HashMap<String, String>();
            for (String synonym : synonyms.split("\\|")) {
                String[] parts = synonym.split(":");
                if (parts.length <= 1 || Strings.isEmpty((String)parts[0])) continue;
                words.put(parts[0], parts[1]);
            }
            IndexAnalyzers.saveSynonyms(template, words);
            IndexMaster.getInstance().updateTemplateIndexes(template, db);
        }
        if ((synonymsFile = IndexAnalyzers.getSynonymFile(template)) == null || !synonymsFile.exists() || !synonymsFile.isFile()) {
            res.getXMLWriter().emptyElement("synonyms");
        } else {
            try (FileInputStream in = new FileInputStream(synonymsFile);){
                IOUtils.copy((InputStream)in, (Writer)res.getPrinter());
            }
        }
    }
}

