/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.search.flint.DocumentContent;
import com.pageseeder.search.flint.FolderContent;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSHelpContent;
import com.pageseeder.search.flint.URLContent;
import com.pageseeder.search.flint.XLinkContent;
import com.pageseeder.search.url.URLsIndex;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentFetcher;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.IndexJob;

public final class PSContentFetcher
implements ContentFetcher {
    public Content getContent(IndexJob job) {
        Index idx = job.getIndex();
        String cid = job.getContentID();
        ContentType ctype = job.getContentType();
        if ("help".equals(idx.getIndexID())) {
            return new PSHelpContent(cid);
        }
        if (ctype == PSContentType.COMMENT) {
            Long id = IndexUtils.getCommentContentID(cid);
            if (IndexUtils.isContentDeleted(cid)) {
                return XLinkContent.deleteXLinkContent(id, false);
            }
            return new XLinkContent(id, Long.parseLong(idx.getIndexID()), false);
        }
        if (ctype == PSContentType.TASK) {
            Long id = IndexUtils.getCommentContentID(cid);
            if (IndexUtils.isContentDeleted(cid)) {
                return XLinkContent.deleteXLinkContent(id, true);
            }
            return new XLinkContent(id, Long.parseLong(idx.getIndexID()), true);
        }
        Long[] ids = IndexUtils.getURIContentIDs(cid);
        if (ctype == PSContentType.FOLDER) {
            return new FolderContent(ids[0], Long.parseLong(idx.getIndexID()));
        }
        if (ctype == PSContentType.URL) {
            if (IndexUtils.isContentDeleted(cid)) {
                return URLContent.deleteURLContent(ids[0], ids[1]);
            }
            Long gpid = idx instanceof URLsIndex ? null : Long.valueOf(Long.parseLong(idx.getIndexID()));
            return new URLContent(ids[0], gpid, ids[1], true);
        }
        if (ctype == PSContentType.DOCUMENT) {
            if (IndexUtils.isContentDeleted(cid)) {
                return DocumentContent.deleteDocumentContent(ids[0], ids[1]);
            }
            return new DocumentContent(ids[0], Long.parseLong(idx.getIndexID()), ids[1], job);
        }
        return null;
    }
}

