/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexChangesListener;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentFetcher;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.search.flint.PSTranslatorFactory;
import com.pageseeder.search.flint.PSTranslatorWrapper;
import com.pageseeder.search.flint.XLinkContent;
import com.pageseeder.search.flint.log.PSIndexListener;
import com.pageseeder.search.help.HelpIndex;
import com.pageseeder.search.queries.AutoSuggestQuery;
import com.pageseeder.search.url.URLsIndex;
import com.pageseeder.search.utils.SearchUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexManager;
import org.pageseeder.flint.IndexOpenException;
import org.pageseeder.flint.OpenIndexManager;
import org.pageseeder.flint.Requester;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentFetcher;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.content.ContentTranslatorFactory;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.flint.log.NoOpListener;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.MultipleIndexReader;
import org.pageseeder.flint.lucene.query.PredicateSearchQuery;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.FieldFacet;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class IndexMaster {
    private static final String CODEC_ERROR_MESSAGE = "Could not load codec";
    public static final String INDEXES_LOCATION = "/WEB-INF/state/index";
    private static final int DEFAULT_MAX_OPEN_INDEX = 50;
    private static final int DEFAULT_NB_INDEXING_THREADS = 2;
    private static final int SLOW_INDEX_SIZE = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexMaster.class);
    private static IndexMaster singleton = null;
    private static final float THREAD_PRIORITY = 3.0f;
    private final File webapp;
    private final IndexManager indexManager;
    private final IndexListener listener;
    private final PSTranslatorFactory psTranslatorFactory;
    private final ConcurrentHashMap<Long, GroupIndex> indexes = new ConcurrentHashMap();
    private final int slowSize;
    private final HelpIndex _helpIndex;
    private final URLsIndex _urlsIndex;

    public static IndexMaster getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("Indexing has been disabled");
        }
        return singleton;
    }

    public static void initialise(File rootdir) {
        if (singleton != null) {
            throw new IllegalStateException("Indexing has already been initialised");
        }
        singleton = new IndexMaster(rootdir);
    }

    private IndexMaster(File webapp) {
        PSIndexListener lst;
        this.webapp = webapp;
        try {
            lst = new PSIndexListener();
        }
        catch (Exception ex) {
            lst = NoOpListener.getInstance();
            LOGGER.error("Failed to create the Index Logger so all Indexing log messages will be ignored", (Throwable)ex);
        }
        int maxOpenIndex = GlobalSettings.getInt((String)"maxOpenedIndexes", (int)50);
        OpenIndexManager.setMaxOpenedIndexes((int)maxOpenIndex);
        this.listener = lst;
        int nbThreads = GlobalSettings.getInt((String)"maxIndexingThreads", (int)2);
        this.indexManager = new IndexManager((ContentFetcher)new PSContentFetcher(), this.listener, nbThreads, true);
        this.slowSize = GlobalSettings.getInt((String)"slowIndexingSize", (int)1000000);
        this.psTranslatorFactory = new PSTranslatorFactory();
        this.indexManager.registerTranslatorFactory((ContentTranslatorFactory)this.psTranslatorFactory);
        this.indexManager.setDefaultTranslator((ContentTranslator)new PSTranslatorWrapper(null));
        this.indexManager.setThreadPriority(Math.round(3.0f));
        Catalogs.setRoot((File)new File(this.webapp, INDEXES_LOCATION));
        this._helpIndex = this.createHelpIndex();
        this._urlsIndex = this.createURLsIndex();
        ChangesManager.registerListener((ChangesListener)new IndexChangesListener(this));
    }

    public boolean isIndexable(Database db, Group grp) {
        if (grp == null || "admin".equals(grp.getName()) || "public".equals(grp.getName()) || GroupRule.isProject((Group)grp)) {
            return false;
        }
        try {
            return this.isIndexable(grp, GroupProperties.get((Database)db, (Group)grp));
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Query failed when loading properties for group {}", (Object)grp.getName(), (Object)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load properties for group {}", (Object)grp.getName(), (Object)ex);
        }
        return true;
    }

    public boolean isIndexable(Group grp, Properties props) {
        if (grp == null || "admin".equals(grp.getName()) || "public".equals(grp.getName())) {
            return false;
        }
        return !GroupRule.isArchived((Group)grp) && (props == null || "false".equals(props.getProperty("disableIndexing", "false")));
    }

    public boolean isIndexableServer() {
        return "false".equals(Settings.getString((SettingsFile)SettingsFile.GROUP, (String)"disableIndexing", (String)"false"));
    }

    public void indexBatch(Database db, IndexBatch batch, XLink xl, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, batch, xl, groups, requester, false);
    }

    public void index(Database db, XLink xl, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, xl, groups, requester, false);
    }

    public void indexBatch(Database db, IndexBatch batch, URI uri, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, batch, uri, null, groups, requester, false);
    }

    public void index(Database db, URI uri, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, uri, null, groups, requester, false);
    }

    public void indexBatch(Database db, IndexBatch batch, URI uri, Long releaseID, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, batch, uri, releaseID, groups, requester, false);
    }

    public void index(Database db, URI uri, Long releaseID, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, uri, releaseID, groups, requester, false);
    }

    public void indexUrgent(Database db, URI uri, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, uri, null, groups, requester, true);
    }

    public void indexUrgent(Database db, URI uri, Long releaseID, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, uri, releaseID, groups, requester, true);
    }

    public void indexUrgent(Database db, XLink xl, Iterator<Group> groups, PSRequester requester) {
        this.launchIndexJob(db, null, xl, groups, requester, true);
    }

    void deleteUrgent(Database db, Long xlid, Iterator<Group> groups, PSRequester requester) {
        if (!groups.hasNext() || xlid == null || db == null) {
            return;
        }
        String cid = IndexUtils.buildCommentContentID(xlid, true);
        while (groups.hasNext()) {
            Group grp = groups.next();
            if (!this.isIndexable(db, grp)) continue;
            this.launchIndexJob(cid, PSContentType.COMMENT, null, grp, db, null, requester, true, false);
            this.launchIndexJob(cid, PSContentType.TASK, null, grp, db, null, requester, true, false);
        }
    }

    void deleteFolder(Database db, Long uriID, Iterator<Group> groups, PSRequester requester) {
        this.deleteURI(db, uriID, PSContentType.FOLDER, groups, requester);
    }

    void deleteDocument(Database db, Long uriID, Iterator<Group> groups, PSRequester requester) {
        this.deleteURI(db, uriID, PSContentType.DOCUMENT, groups, requester);
    }

    private void deleteURI(Database db, Long uriID, PSContentType type, Iterator<Group> groups, PSRequester requester) {
        if (!groups.hasNext() || uriID == null || db == null) {
            return;
        }
        String cid = IndexUtils.buildURIContentID(uriID, true);
        while (groups.hasNext()) {
            Group grp = groups.next();
            if (!this.isIndexable(db, grp)) continue;
            this.launchIndexJob(cid, type, null, grp, db, null, requester, true, false);
        }
    }

    synchronized void clearIndex(Long groupid, String name, PSRequester requester) {
        GroupIndex index = this.indexes.get(groupid);
        if (index != null) {
            this.indexManager.clear((Index)index, (Requester)requester.cloneForGroup(name), IndexJob.Priority.HIGH);
        }
    }

    public void clearHelpIndex(IndexBatch batch, PSRequester requester) {
        if (this._helpIndex != null) {
            this.indexManager.clear(batch, (Index)this._helpIndex, (Requester)requester, IndexJob.Priority.HIGH);
        }
    }

    public void clearURLsIndex(IndexBatch batch, PSRequester requester) {
        if (this._urlsIndex != null) {
            this.indexManager.clear(batch, (Index)this._urlsIndex, (Requester)requester, IndexJob.Priority.HIGH);
        }
    }

    public void closeIndex(Long groupid) {
        GroupIndex idx = this.indexes.get(groupid);
        if (idx != null) {
            idx.close();
        }
    }

    public void clearIndex(IndexBatch batch, Database db, Group group, PSRequester requester, boolean urgent) {
        GroupIndex index = this.getIndex(db, group);
        this.indexManager.clear(batch, (Index)index, (Requester)requester.cloneForGroup(group.getName()), urgent ? IndexJob.Priority.HIGH : IndexJob.Priority.LOW);
    }

    public static void removeIndexFiles(Long groupid) {
        File root = new File(Settings.getContextPath(), INDEXES_LOCATION + File.pathSeparator + groupid);
        try {
            IndexMaster.removeIndexFiles(root);
        }
        catch (IOException ex2) {
            LOGGER.error("Failed to delete files from index {}", (Object)root.toPath());
        }
    }

    public HelpIndex getHelpIndex() {
        return this._helpIndex;
    }

    public URLsIndex getURLsIndex() {
        return this._urlsIndex;
    }

    public void release(Database db, Group group, IndexReader reader) throws IndexException {
        if (reader == null) {
            return;
        }
        GroupIndex index = this.getIndex(db, group);
        LuceneIndexQueries.release((Index)index, (IndexReader)reader);
    }

    public IndexSearcher getSearcher(Database db, Group group) throws IndexException {
        GroupIndex index = this.getIndex(db, group);
        return LuceneIndexQueries.grabSearcher((Index)index);
    }

    public void release(Database db, Group group, IndexSearcher searcher) throws IndexException {
        if (searcher == null) {
            return;
        }
        GroupIndex index = this.getIndex(db, group);
        LuceneIndexQueries.release((Index)index, (IndexSearcher)searcher);
    }

    public void releaseSilently(Database db, Group group, IndexSearcher searcher) {
        if (searcher == null) {
            return;
        }
        GroupIndex index = this.getIndex(db, group);
        LuceneIndexQueries.releaseQuietly((Index)index, (IndexSearcher)searcher);
    }

    public void translateXLink(Database db, XLink xl, boolean asTask, Group grp, Map<String, String> parameters, Writer out) throws IndexException {
        if (xl == null) {
            throw new IllegalArgumentException("Cannot index a null XLink");
        }
        if (!XLinkRule.isIndexable((XLink)xl)) {
            throw new IllegalArgumentException("Cannot index XLink with role " + xl.getContentRole());
        }
        XLinkContent content = new XLinkContent(xl.getId(), grp.getId(), asTask);
        GroupIndex index = this.getIndex(db, grp);
        this.indexManager.contentToIXML((Index)index, (Content)content, parameters, out);
    }

    public void translate(Database db, Group grp, URI uri, Long releaseID, boolean withGroups, Map<String, String> parameters, Writer out) throws IndexException {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot index a null URI");
        }
        Map<String, String> params = IndexUtils.buildParameters(uri, grp, releaseID);
        if (parameters != null) {
            params.putAll(parameters);
        }
        Content content = IndexUtils.toContent(uri, grp == null ? null : grp.getId(), releaseID, withGroups);
        LuceneIndex index = URIs.isExternal((URI)uri) && grp == null ? this._urlsIndex : this.getIndex(db, grp);
        this.indexManager.contentToIXML((Index)index, content, params, out);
    }

    public List<FlintDocument> buildDocuments(Database db, Group grp, URI uri, Long releaseID, boolean withGroups, Map<String, String> parameters) throws IndexException {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot index a null URI");
        }
        Map<String, String> params = IndexUtils.buildParameters(uri, grp, releaseID);
        if (parameters != null) {
            params.putAll(parameters);
        }
        Content content = IndexUtils.toContent(uri, grp == null ? null : grp.getId(), releaseID, withGroups);
        LuceneIndex index = URIs.isExternal((URI)uri) && grp == null ? this._urlsIndex : this.getIndex(db, grp);
        List documents = this.indexManager.contentToDocuments((Index)index, content, params);
        Collection fields = index.getFields(content);
        if (!fields.isEmpty()) {
            for (FlintDocument doc : documents) {
                for (FlintField field : fields) {
                    doc.removeFields(field.name());
                }
                for (FlintField field : fields) {
                    doc.add(field);
                }
            }
        }
        return documents;
    }

    public void process(Group grp, URI uri, Long releaseID, boolean withGroups, Writer out) throws IndexException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot index a null URI");
        }
        Content content = IndexUtils.toContent(uri, grp == null ? null : grp.getId(), releaseID, withGroups);
        this.processContent(content, out);
    }

    public void process(XLink xl, boolean asTask, Group grp, Writer out) throws IndexException, IOException {
        if (xl == null) {
            throw new IllegalArgumentException("Cannot index a null XLink");
        }
        this.processContent(new XLinkContent(xl.getId(), grp.getId(), asTask), out);
    }

    private void processContent(Content content, Writer out) throws IndexException, IOException {
        int read;
        Reader source;
        ContentTranslator translator = this.psTranslatorFactory.createTranslator(content.getMediaType());
        if (translator == null) {
            translator = new PSTranslatorWrapper(content.getMediaType());
        }
        if ((source = translator.translate(content)) == null) {
            out.write("<root><status>error</status><message>Translator returned null content</message></root>");
            return;
        }
        char[] buffer = new char[1024];
        while ((read = source.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        source.close();
    }

    public SearchResults search(Database db, Group grp, String predicate, String orderby, int hitsPerPage, int currentPage) throws IndexException {
        if (!this.isIndexable(db, grp)) {
            return null;
        }
        GroupIndex index = this.getIndex(db, grp);
        PredicateSearchQuery query = new PredicateSearchQuery(predicate, index.getAnalyzer(), orderby);
        SearchPaging pages = new SearchPaging();
        if (hitsPerPage > 0) {
            pages.setHitsPerPage(hitsPerPage);
        }
        if (currentPage > 0) {
            pages.setPage(currentPage);
        }
        return LuceneIndexQueries.query((Index)index, (SearchQuery)query, (SearchPaging)pages);
    }

    public SearchResults search(Database db, Group grp, SearchQuery query, int hitsPerPage, int currentPage) throws IndexException {
        if (!this.isIndexable(db, grp)) {
            return null;
        }
        GroupIndex index = this.getIndex(db, grp);
        SearchPaging pages = new SearchPaging();
        if (hitsPerPage > 0) {
            pages.setHitsPerPage(hitsPerPage);
        }
        if (currentPage > 0) {
            pages.setPage(currentPage);
        }
        return LuceneIndexQueries.query((Index)index, (SearchQuery)query, (SearchPaging)pages);
    }

    public SearchResults search(Database db, List<Group> grps, SearchQuery query, int hitsPerPage, int currentPage) throws IndexException {
        ArrayList<GroupIndex> indexes = new ArrayList<GroupIndex>(grps.size());
        for (Group grp : grps) {
            if (!this.isIndexable(db, grp)) continue;
            GroupIndex index = this.getIndex(db, grp);
            if (index != null) {
                indexes.add(index);
                continue;
            }
            LOGGER.warn("Failed to load index for {}", (Object)grp.getName());
        }
        SearchPaging pages = new SearchPaging();
        if (hitsPerPage > 0) {
            pages.setHitsPerPage(hitsPerPage);
        }
        if (currentPage > 0) {
            pages.setPage(currentPage);
        }
        return LuceneIndexQueries.query(indexes, (SearchQuery)query, (SearchPaging)pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults getSuggestions(List<Index> indexes, List<String> fields, String question, int max, boolean andBetweenTerms, boolean prefixLastTermOnly, Query filter, String predicate) throws IOException, IndexException {
        AutoSuggestQuery query;
        URLsIndex urlsIndex = null;
        Analyzer analyzer = null;
        for (Index index : indexes) {
            if (index instanceof GroupIndex) {
                analyzer = ((GroupIndex)index).getAnalyzer();
            } else if (index instanceof URLsIndex) {
                urlsIndex = (URLsIndex)index;
            }
            if (analyzer == null) continue;
            break;
        }
        if (analyzer == null && urlsIndex != null) {
            analyzer = urlsIndex.getAnalyzer();
        }
        if (analyzer == null) {
            LOGGER.error("Failed to load analyzer to search suggestions in {} groups!", (Object)indexes.size());
            throw new IndexException("No analyzer found", (Exception)new NullPointerException());
        }
        analyzer = IndexAnalyzers.cloneAnalyzerForQuery(analyzer);
        Query predicateQuery = null;
        if (predicate != null && !"".equals(predicate)) {
            StandardQueryParser parser = new StandardQueryParser(analyzer);
            parser.setAllowLeadingWildcard(false);
            try {
                predicateQuery = parser.parse(predicate, "pstype");
            }
            catch (QueryNodeException ex) {
                LOGGER.error("Unable to parse index predicate", (Throwable)ex);
            }
        }
        Query condition = null;
        if (predicateQuery == null && filter != null) {
            condition = filter;
        } else if (filter == null && predicateQuery != null) {
            condition = predicateQuery;
        } else if (predicateQuery != null) {
            BooleanQuery.Builder combined = new BooleanQuery.Builder();
            SearchUtils.addMustClause(combined, filter);
            SearchUtils.addMustClause(combined, predicateQuery);
            condition = combined.build();
        }
        SearchPaging pages = new SearchPaging();
        if (max > 0) {
            pages.setHitsPerPage(max);
        }
        MultipleIndexReader multiIndexes = LuceneIndexQueries.getMultipleIndexReader(indexes);
        try {
            IndexReader reader = multiIndexes.grab();
            query = new AutoSuggestQuery(question, fields, analyzer, condition);
            query.setPrefixLastTermOnly(prefixLastTermOnly);
            query.setUnionTermResults(!andBetweenTerms);
            query.compute(reader);
        }
        finally {
            multiIndexes.releaseSilently();
        }
        try {
            return LuceneIndexQueries.query(indexes, (SearchQuery)query, (SearchPaging)pages);
        }
        catch (IndexSearcher.TooManyClauses ex) {
            throw new IndexException("Failed to run suggest query because of too many prefixes", (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Term> getPrefixTerms(Index index, List<String> fields, String text, long max) throws IOException, IndexException {
        ArrayList<Term> terms;
        block5: {
            IndexReader reader = null;
            terms = new ArrayList<Term>();
            try {
                reader = LuceneIndexQueries.grabReader((Index)index);
                for (String field : fields) {
                    for (String value : Terms.prefix((IndexReader)reader, (Term)new Term(field, text))) {
                        terms.add(new Term(field, value));
                        if ((long)terms.size() != max) continue;
                        break block5;
                    }
                }
            }
            finally {
                LuceneIndexQueries.releaseQuietly((Index)index, (IndexReader)reader);
            }
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Term> getPrefixTerms(List<Index> indexes, List<String> fields, String text, long max) throws IOException, IndexException {
        ArrayList<Term> terms;
        block7: {
            if (indexes.size() == 1) {
                return this.getPrefixTerms(indexes.get(0), fields, text, max);
            }
            MultipleIndexReader reader = null;
            terms = new ArrayList<Term>();
            try {
                reader = LuceneIndexQueries.getMultipleIndexReader(indexes);
                for (String field : fields) {
                    for (String value : Terms.prefix((IndexReader)reader.grab(), (Term)new Term(field, text))) {
                        terms.add(new Term(field, value));
                        if ((long)terms.size() != max) continue;
                        break block7;
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.releaseSilently();
                }
            }
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Term> getSimilarTerms(Index index, List<String> fields, String text, int similarity, long max) throws IOException, IndexException {
        ArrayList<Term> terms;
        block6: {
            IndexReader reader = null;
            terms = new ArrayList<Term>();
            if (similarity <= 0) {
                return terms;
            }
            try {
                reader = LuceneIndexQueries.grabReader((Index)index);
                for (String field : fields) {
                    ArrayList values = new ArrayList();
                    Terms.fuzzy((IndexReader)reader, values, (Term)new Term(field, text), (int)(similarity > 2 ? 2 : 1));
                    for (String value : values) {
                        terms.add(new Term(field, value));
                        if ((long)terms.size() != max) continue;
                        break block6;
                    }
                }
            }
            finally {
                LuceneIndexQueries.releaseQuietly((Index)index, (IndexReader)reader);
            }
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Term> getSimilarTerms(List<Index> indexes, List<String> fields, String text, int similarity, long max) throws IOException, IndexException {
        ArrayList<Term> terms;
        block8: {
            if (indexes.size() == 1) {
                return this.getSimilarTerms(indexes.get(0), fields, text, similarity, max);
            }
            terms = new ArrayList<Term>();
            if (similarity <= 0) {
                return terms;
            }
            MultipleIndexReader reader = null;
            try {
                reader = LuceneIndexQueries.getMultipleIndexReader(indexes);
                for (String field : fields) {
                    ArrayList values = new ArrayList();
                    Terms.fuzzy((IndexReader)reader.grab(), values, (Term)new Term(field, text), (int)(similarity > 2 ? 2 : 1));
                    for (String value : values) {
                        terms.add(new Term(field, value));
                        if ((long)terms.size() != max) continue;
                        break block8;
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.releaseSilently();
                }
            }
        }
        return terms;
    }

    public FieldFacet computeFieldFacet(Database db, Group group, String field, Query base) throws IndexException, IOException {
        GroupIndex index = this.getIndex(db, group);
        IndexReader reader = LuceneIndexQueries.grabReader((Index)index);
        FieldFacet facet = FieldFacet.newFacet((String)field, (IndexReader)reader);
        LuceneIndexQueries.release((Index)index, (IndexReader)reader);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher((Index)index);
        facet.compute(searcher, base);
        LuceneIndexQueries.release((Index)index, (IndexSearcher)searcher);
        return facet;
    }

    public void writeIndexStatus(Database db, Group grp, UniversalPrinter out) {
        if (grp == null || db == null) {
            this.loadStatus(null, out);
        } else {
            this.loadStatus(this.getIndex(db, grp), out);
        }
    }

    public List<IndexJob> getIndexJobs(Database db, Group grp) {
        if (grp == null) {
            return this.indexManager.getStatus();
        }
        GroupIndex index = this.getIndex(db, grp);
        return this.indexManager.getStatus((Index)index);
    }

    public static boolean shouldIgnoreURI(String path) {
        String siteprefix = GlobalSettings.getSitePrefix();
        return path.startsWith(siteprefix + "/servlet/com.pageseeder.general");
    }

    public synchronized void updateIndex(Group group, Database db) {
        if (group == null) {
            return;
        }
        GroupIndex index = this.getIndex(db, group);
        index.close();
        this.indexes.remove(group.getId());
        this.getIndex(db, group);
    }

    public void updateTemplateIndexes(String template, Database db) {
        IndexMaster master = IndexMaster.getInstance();
        try {
            Collection groups = DatabaseQuery.getGroupsByOwnerDirectoryNonArchivedCol((Database)db, (String)template);
            for (Group group : groups) {
                master.updateIndex(group, db);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to load groups with template " + template + ": " + ex.getMessage());
        }
    }

    public Question newQuestion(Database db, Group group, List<String> fields, String question) {
        GroupIndex index = this.getIndex(db, group);
        return new Question.Builder().question(question).fields(fields).analyzerAndCatalog(index.getAnalyzer(), null).build();
    }

    public List<Question> similar(Database db, Group group, Question question) throws IOException, IndexException {
        if (question == null) {
            return null;
        }
        GroupIndex index = this.getIndex(db, group);
        IndexReader reader = LuceneIndexQueries.grabReader((Index)index);
        List similar = question.similar(reader);
        LuceneIndexQueries.release((Index)index, (IndexReader)reader);
        return similar;
    }

    public int count(Database db, Group group, Query query) throws IOException, IndexException {
        GroupIndex index = this.getIndex(db, group);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher((Index)index);
        int count = Documents.count((IndexSearcher)searcher, (Query)query);
        LuceneIndexQueries.release((Index)index, (IndexSearcher)searcher);
        return count;
    }

    public Bucket<Question> similar(Database db, Group group, Question question, int size) throws IOException, IndexException {
        if (question == null) {
            return null;
        }
        GroupIndex index = this.getIndex(db, group);
        IndexReader reader = LuceneIndexQueries.grabReader((Index)index);
        List similar = question.similar(reader);
        LuceneIndexQueries.release((Index)index, (IndexReader)reader);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher((Index)index);
        Bucket bucket = new Bucket(size);
        for (Question s : similar) {
            DocumentCounter counter = new DocumentCounter();
            searcher.search(s.toQuery(), (Collector)counter);
            bucket.add((Object)s, counter.getCount());
        }
        LuceneIndexQueries.release((Index)index, (IndexSearcher)searcher);
        return bucket;
    }

    public Bucket<Question> similar(List<Index> indexes, Question question, int size) throws IOException, IndexException {
        if (question == null) {
            return null;
        }
        MultipleIndexReader multiIndexes = LuceneIndexQueries.getMultipleIndexReader(indexes);
        IndexReader reader = multiIndexes.grab();
        List similar = question.similar(reader);
        IndexSearcher searcher = new IndexSearcher(reader);
        Bucket bucket = new Bucket(size);
        for (Question s : similar) {
            if (s.toQuery() == null) continue;
            DocumentCounter counter = new DocumentCounter();
            searcher.search(s.toQuery(), (Collector)counter);
            bucket.add((Object)s, counter.getCount());
        }
        multiIndexes.releaseSilently();
        return bucket;
    }

    public IndexListener getListener() {
        return this.listener;
    }

    public String getCatalog(Long groupID) {
        GroupIndex index = groupID == null ? null : this.indexes.get(groupID);
        return index == null ? null : index.getCatalog();
    }

    public boolean indexHelpDocument(String path, IndexBatch batch, PSRequester requester) {
        if (this._helpIndex == null) {
            return false;
        }
        PSContentType ctype = PSContentType.DOCUMENT;
        IndexJob.Priority priority = IndexJob.Priority.LOW;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("psid-field-value", path);
        params.put("groupname", "~help");
        this.indexManager.indexBatch(batch, path, (ContentType)ctype, (Index)this._helpIndex, (Requester)requester, priority, false, params);
        return true;
    }

    public boolean indexURL(Long uriid, boolean delete, IndexBatch batch, PSRequester requester) {
        if (this._urlsIndex == null || !this.isIndexableServer()) {
            return false;
        }
        String id = IndexUtils.buildURIContentID(uriid, delete);
        PSContentType ctype = PSContentType.URL;
        IndexJob.Priority priority = IndexJob.Priority.LOW;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("psid-field-value", String.valueOf(uriid));
        this.indexManager.indexBatch(batch, id, (ContentType)ctype, (Index)this._urlsIndex, (Requester)requester, priority, false, params);
        return true;
    }

    private void launchIndexJob(Database db, IndexBatch batch, XLink xl, Iterator<Group> grps, PSRequester requester, boolean urgent) {
        if (!grps.hasNext() || xl == null || db == null) {
            return;
        }
        if (!XLinkRule.isIndexable((XLink)xl) || !xl.getAccepted().booleanValue()) {
            return;
        }
        String cid = IndexUtils.buildCommentContentID(xl.getId(), false);
        while (grps.hasNext()) {
            Group grp = grps.next();
            if (!this.isIndexable(db, grp)) continue;
            this.launchIndexJob(cid, PSContentType.COMMENT, batch, grp, db, null, requester, urgent, false);
            this.launchIndexJob(cid, PSContentType.TASK, batch, grp, db, null, requester, urgent, false);
        }
    }

    private void launchIndexJob(Database db, IndexBatch batch, URI uri, Long releaseID, Iterator<Group> grps, PSRequester requester, boolean urgent) {
        if (!grps.hasNext() || uri == null || db == null || IndexMaster.shouldIgnoreURI(uri.getPath()) || releaseID != null && URIRule.isFolder((URI)uri)) {
            return;
        }
        ArrayList<Group> allgroups = new ArrayList<Group>();
        while (grps.hasNext()) {
            Group grp;
            block7: {
                grp = grps.next();
                if (!this.isIndexable(db, grp)) continue;
                if (releaseID != null) {
                    try {
                        if ("false".equals(GroupProperties.get((Database)db, (Group)grp).getProperty("indexVersions", "false"))) {
                        }
                        break block7;
                    }
                    catch (QueryFailedException | IOException ex) {
                        LOGGER.error("Failed to load group properties for {}, versions will not be indexed", (Object)grp.getName(), (Object)ex);
                    }
                    continue;
                }
            }
            allgroups.add(grp);
        }
        boolean slowLane = this.isSlowLane(uri);
        String cid = IndexUtils.buildURIContentID(uri.getId(), releaseID, false);
        PSContentType ctype = IndexUtils.toContentType(uri);
        for (Group grp : allgroups) {
            this.launchIndexJob(cid, ctype, batch, grp, db, IndexUtils.buildParameters(uri, grp, releaseID), requester, urgent, slowLane);
        }
    }

    void launchIndexJob(String contentid, PSContentType ctype, IndexBatch batch, Group group, Database db, Map<String, String> params, PSRequester requester, boolean urgent, boolean slowLane) {
        if (contentid == null || ctype == null || group == null) {
            return;
        }
        IndexJob.Priority priority = urgent ? IndexJob.Priority.HIGH : IndexJob.Priority.LOW;
        GroupIndex index = this.getIndex(db, group);
        PSRequester cloned = requester.cloneForGroup(group.getName());
        if (batch != null) {
            this.indexManager.indexBatch(batch, contentid, (ContentType)ctype, (Index)index, (Requester)cloned, priority, false, slowLane, params);
        } else {
            this.indexManager.index(contentid, (ContentType)ctype, (Index)index, (Requester)cloned, priority, slowLane, params);
            if (urgent) {
                this.indexManager.getStatus((Index)index).stream().filter(job -> job.isBatch() && job.isClearJob()).forEach(job -> {
                    job.getBatch().increaseTotal();
                    this.indexManager.indexBatch(job.getBatch(), contentid, (ContentType)ctype, (Index)index, job.getRequester(), IndexJob.Priority.LOW, false, slowLane, params);
                });
            }
        }
    }

    private void loadStatus(GroupIndex index, UniversalPrinter out) {
        List jobs = this.indexManager.getStatus((Index)index);
        out.startObject("status");
        if (index != null) {
            out.startObject("index");
            out.field("groupid", index.getIndexID());
            out.endObject();
        }
        out.startObject("jobs");
        out.field("total", (long)jobs.size());
        HashMap<ContentType, Integer> counts = new HashMap<ContentType, Integer>();
        for (IndexJob indexJob : jobs) {
            counts.put(indexJob.getContentType(), !counts.containsKey(indexJob.getContentType()) ? 1 : (Integer)counts.get(indexJob.getContentType()) + 1);
        }
        for (Map.Entry entry : counts.entrySet()) {
            out.field(((ContentType)entry.getKey()).toString().toLowerCase(), (long)((Integer)entry.getValue()).intValue());
        }
        out.endObject();
        out.endObject();
        out.flush();
    }

    public synchronized Collection<GroupIndex> ListIndex() {
        return Collections.unmodifiableCollection(this.indexes.values());
    }

    public synchronized GroupIndex getIndex(Database db, Group grp) {
        return this.getIndex(db, grp, true);
    }

    public void removeIndex(long grpid) {
        File dir;
        GroupIndex index = this.indexes.get(grpid);
        if (index != null) {
            index.close();
        }
        if ((dir = this.getIndexDirectory(grpid)).exists()) {
            try {
                IndexMaster.removeIndexFiles(dir);
                Files.delete(dir.toPath());
            }
            catch (IOException ex) {
                LOGGER.error("Failed to delete index files for index {}", (Object)grpid, (Object)ex);
            }
        }
    }

    public GroupIndex getIndex(Database db, Group grp, boolean firsttime) {
        if (grp == null) {
            throw new IllegalArgumentException("Failed to create index as group is null");
        }
        GroupIndex index = this.indexes.get(grp.getId());
        if (index == null) {
            File dir = this.getIndexDirectory(grp.getId());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create index directory " + dir.getAbsolutePath());
            }
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IllegalArgumentException("Invalid index directory " + dir.getAbsolutePath());
            }
            try {
                Analyzer analyzer = IndexAnalyzers.getAnalyzer(grp.getOwnerDirectory());
                index = new GroupIndex(dir, grp, analyzer, this.webapp);
            }
            catch (IndexOpenException ex) {
                if (firsttime) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Failed to wait 2s for other index to be created");
                    }
                    return this.getIndex(db, grp, false);
                }
                throw new IllegalArgumentException("Failed to create index already in use", ex);
            }
            catch (IllegalArgumentException ex) {
                if (firsttime && ex.getMessage() != null && ex.getMessage().contains(CODEC_ERROR_MESSAGE)) {
                    try {
                        IndexMaster.removeIndexFiles(dir);
                        LOGGER.error("Cleared group index as it was incompatible. Group {} must be reindexed.", (Object)grp.getName());
                        return this.getIndex(db, grp, false);
                    }
                    catch (IOException ex2) {
                        LOGGER.error("Failed to delete old group index. Group {} search is disabled.");
                        return null;
                    }
                }
                throw ex;
            }
            catch (IndexException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to read index definition " + ex.getMessage());
            }
            catch (SAXException ex) {
                throw new IllegalArgumentException("Failed to parse index definition " + ex.getMessage());
            }
            this.indexes.put(grp.getId(), index);
            this.reloadGroupProperties(grp, db);
        }
        return index;
    }

    void reloadGroupProperties(Group grp, Database db) {
        GroupIndex index = this.indexes.get(grp.getId());
        if (index != null) {
            try {
                String propValue = GroupProperties.get((Database)db, (Group)grp).getProperty("indexXFields", "false");
                index.addParameters(Collections.singletonMap("ps-indexXFields", propValue));
            }
            catch (QueryFailedException | IOException ex) {
                LOGGER.warn("Failed to load group properties for {}", (Object)grp.getName(), (Object)ex);
            }
        }
    }

    public void destroy() {
        Catalogs.saveAll();
        this.indexManager.stop();
    }

    boolean isSlowLane(URI uri) {
        return !URIRule.isPSML((URI)uri) && !URIRule.isFolder((URI)uri) && !URIs.isExternal((URI)uri) && (uri.getSize() == null || uri.getSize() > (long)this.slowSize);
    }

    private File getIndexDirectory(long grpid) {
        return new File(this.webapp, "/WEB-INF/state/index/" + grpid);
    }

    private HelpIndex createHelpIndex() {
        return this.createHelpIndex(true);
    }

    private HelpIndex createHelpIndex(boolean firstTime) {
        File dir = new File(this.webapp, "/WEB-INF/state/index/help");
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("Failed to create index directory {} for help content help search will be disabled", (Object)dir.getAbsolutePath());
            return null;
        }
        try {
            Analyzer analyzer = IndexAnalyzers.getAnalyzer("default");
            return new HelpIndex(dir, analyzer);
        }
        catch (IllegalArgumentException ex) {
            if (firstTime && ex.getMessage() != null && ex.getMessage().contains(CODEC_ERROR_MESSAGE)) {
                try {
                    IndexMaster.removeIndexFiles(dir);
                    LOGGER.error("Cleared help index as it was incompatible. Help must be reindexed.");
                    return this.createHelpIndex(false);
                }
                catch (IOException ex2) {
                    LOGGER.error("Failed to delete old help index. Help search is disabled.");
                    return null;
                }
            }
            LOGGER.error("Failed to create help index. Help search is disabled.", (Throwable)ex);
        }
        catch (IOException | IndexException | SAXException ex) {
            LOGGER.error("Failed to create help index. Help search is disabled.", ex);
        }
        return null;
    }

    private URLsIndex createURLsIndex() {
        return this.createURLsIndex(true);
    }

    private URLsIndex createURLsIndex(boolean firstTime) {
        File dir = new File(this.webapp, "/WEB-INF/state/index/urls");
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("Failed to create index directory {} for urls", (Object)dir.getAbsolutePath());
            return null;
        }
        try {
            Analyzer analyzer = IndexAnalyzers.getAnalyzer("default");
            return new URLsIndex(dir, analyzer);
        }
        catch (IllegalArgumentException ex) {
            if (firstTime && ex.getMessage() != null && ex.getMessage().contains(CODEC_ERROR_MESSAGE)) {
                try {
                    IndexMaster.removeIndexFiles(dir);
                    LOGGER.error("Cleared URLs index as it was incompatible. URLs must be reindexed.");
                    return this.createURLsIndex(false);
                }
                catch (IOException ex2) {
                    LOGGER.error("Failed to delete old URLs index. URLs search is disabled.");
                    return null;
                }
            }
            LOGGER.error("Failed to create URLs index. URLs search is disabled.", (Throwable)ex);
        }
        catch (IOException | IndexException | SAXException ex) {
            LOGGER.error("Failed to create URLs index. URLs search is disabled.", ex);
        }
        return null;
    }

    private static void removeIndexFiles(File dir) throws IOException {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                Files.delete(file.toPath());
            }
        }
    }
}

