/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.search.flint.DeleteRules;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import java.io.File;
import java.io.InputStream;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderContent.class);
    private final Long _id;
    private final Long _groupID;
    private boolean resolved = false;
    private boolean deleted = false;
    private InputStream contentStream = null;

    public FolderContent(Long id, Long groupID) {
        this._id = id;
        this._groupID = groupID;
    }

    public String getContentID() {
        return this._id.toString();
    }

    public ContentType getContentType() {
        return PSContentType.FOLDER;
    }

    public InputStream getSource() {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.deleted) {
            return null;
        }
        return this.contentStream;
    }

    public File getFile() {
        return null;
    }

    public String getMediaType() {
        return "application/vnd.pageseeder.folder";
    }

    public boolean isDeleted() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.deleted;
    }

    public DeleteRule getDeleteRule() {
        return DeleteRules.newFolderDeleteRule(this._id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        block15: {
            if (this.resolved) {
                return;
            }
            Transaction tr = null;
            try {
                Database db = Database.open();
                try {
                    tr = new Transaction(db);
                    tr.begin();
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)this._id);
                    boolean bl = this.deleted = uri == null;
                    if (!this.deleted) {
                        this.deleted = IndexUtils.shouldIgnoreURI(uri, db);
                    }
                    if (!this.deleted) {
                        Group group = DatabaseQuery.getGroupById((Database)db, (Long)this._groupID);
                        DocumentContentResolver psmlResolver = new DocumentContentResolver(this._id, group.getName());
                        psmlResolver.setPSMLFormat(true);
                        this.contentStream = psmlResolver.getContent(db);
                    }
                    tr.commit();
                }
                catch (URIException ex) {
                    Thread.sleep(200L);
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)this._id);
                    if (uri == null) {
                        tr.commit();
                        this.deleted = true;
                        break block15;
                    }
                    if (tr != null) {
                        tr.abort();
                    }
                    throw ex;
                }
                finally {
                    db.close();
                    db = null;
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to resolve content", t);
            }
            finally {
                this.resolved = true;
            }
        }
    }
}

