/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.search.flint.DeleteRules;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentContent.class);
    private final Long _id;
    private final Long _groupID;
    private final Long _releaseID;
    private final IndexJob _job;
    private String mediatype = null;
    private String workflowAsXML = null;
    private String publicationsAsXML = null;
    private String uriAsPSML = null;
    private boolean resolved = false;
    private boolean deleted = false;
    private InputStream contentStream = null;
    private File contentFile = null;

    public DocumentContent(Long id, Long groupid, Long releaseID, @Nullable IndexJob job) {
        this._id = id;
        this._groupID = groupid;
        this._releaseID = releaseID;
        this._job = job;
    }

    public static DocumentContent deleteDocumentContent(Long id, Long releaseID) {
        return new DocumentContent(id, releaseID);
    }

    private DocumentContent(Long id, Long releaseID) {
        this._id = id;
        this._releaseID = releaseID;
        this.deleted = true;
        this._groupID = null;
        this._job = null;
    }

    public String getContentID() {
        return this._id.toString();
    }

    public ContentType getContentType() {
        return PSContentType.DOCUMENT;
    }

    public InputStream getSource() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.isDeleted()) {
            return null;
        }
        return this.contentStream;
    }

    public String getMediaType() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.mediatype;
    }

    public File getFile() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.isDeleted()) {
            return null;
        }
        return this.contentFile;
    }

    public boolean isDeleted() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.deleted;
    }

    public DeleteRule getDeleteRule() {
        if (this._releaseID != null) {
            return DeleteRules.newDeleteSingleDocumentReleaseQuery(this._id, this._releaseID);
        }
        if (this.deleted) {
            return DeleteRules.newDeleteAllDocumentReleasesQuery(this._id);
        }
        return DeleteRules.newDocumentDeleteRule(this._id);
    }

    public String getWorkflowXML() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.workflowAsXML;
    }

    public String getPublicationsXML() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.publicationsAsXML;
    }

    public String getURIAsPSML() {
        return this.uriAsPSML;
    }

    public String toString() {
        return this._id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() throws IndexException {
        if (this.resolved) {
            return;
        }
        try {
            Database db = Database.open();
            Transaction tr = null;
            try {
                tr = new Transaction(db);
                tr.begin();
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)this._id);
                Group group = DatabaseQuery.getGroupById((Database)db, (Long)this._groupID);
                this.resolveDeleted(uri, group, db);
                if (!this.deleted) {
                    this.mediatype = uri.getType();
                    long size = -1L;
                    boolean isPSML = URIRule.isPSML((URI)uri);
                    if (!isPSML) {
                        DocumentContentResolver psmlResolver = new DocumentContentResolver(this._id, group.getName());
                        psmlResolver.setPSMLFormat(true);
                        psmlResolver.setReleaseId(this._releaseID);
                        StringWriter psml = new StringWriter();
                        IOUtils.copy((InputStream)psmlResolver.getContent(db), (Writer)psml, (Charset)StandardCharsets.UTF_8);
                        this.uriAsPSML = XMLUtils.removeXMLDeclaration((StringBuffer)new StringBuffer(psml.toString())).toString();
                        if (uri != null && !URIs.isExternal((URI)uri) && !"folder".equals(uri.getType())) {
                            try (InternalURIFetcher fetcher = new InternalURIFetcher(uri, null);){
                                this.contentFile = fetcher.getFile();
                                size = fetcher.getContentLength();
                            }
                        }
                    }
                    if (this.contentFile == null) {
                        DocumentContentResolver resolver = new DocumentContentResolver(this._id, group.getName());
                        resolver.setReleaseId(this._releaseID);
                        UserDetails.Builder userdetails = new UserDetails.Builder();
                        userdetails.setFlags("admin", "");
                        resolver.setTransclude(userdetails.build());
                        this.contentStream = resolver.getContent(db);
                    }
                    this.workflowAsXML = IndexUtils.getWorkflowXML(db, uri, this._releaseID);
                    this.publicationsAsXML = IndexUtils.getPublicationsXML(db, uri, this._releaseID);
                    if (!isPSML) {
                        if (size >= 0L && (uri.getSize() == null || uri.getSize() != size)) {
                            uri.setSize(Long.valueOf(size));
                        }
                        int maxSize = GlobalSettings.getInt((String)"maxIndexingSize", (int)30000000);
                        if (this._job != null && size > (long)maxSize) {
                            IndexListener listener = IndexMaster.getInstance().getListener();
                            listener.warn(this._job, "Content for document with ID " + uri.getId() + " was not indexed as it exceeds the maxIndexingSize of " + maxSize + " bytes");
                        }
                    }
                }
                tr.commit();
            }
            catch (Exception ex) {
                if (tr != null) {
                    tr.abort();
                }
                throw ex;
            }
            finally {
                db.close();
                db = null;
            }
        }
        catch (IOException ex) {
            throw new IndexException("Failed to resolve content because of a IO error: " + ex.getMessage(), (Exception)ex);
        }
        catch (DatabaseException ex) {
            throw new IndexException("Failed to resolve content because of a Database error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new IndexException("Failed to resolve content: " + ex.getMessage(), ex);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to resolve content", ex);
        }
        finally {
            this.resolved = true;
        }
    }

    private void resolveDeleted(URI uri, Group group, Database db) throws DatabaseException, IOException {
        if (this.deleted) {
            return;
        }
        boolean bl = this.deleted = uri == null || group == null || !URIRule.belongsToGroup((Database)db, (Long)this._id, (String)group.getName());
        if (this.deleted) {
            return;
        }
        this.deleted = IndexUtils.shouldIgnoreURI(uri, db);
        if (this.deleted) {
            return;
        }
        if (this._releaseID != null) {
            XLink release = DatabaseQuery.getXLinkById((Database)db, (Long)this._releaseID);
            this.deleted = release == null || XLinks.isArchived((XLink)release);
        }
    }
}

