/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.Facets;
import com.pageseeder.search.queries.Intervals;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.queries.Ranges;
import com.pageseeder.search.utils.SearchException;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class SearchBase
implements Generator,
SingleCheck,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchBase.class);
    private static final int DEFAULT_MAX_FACET_SIZE = 1000;
    private static final String MAX_FACET_SIZE_PROPERTY = "maxFacetSize";
    private static final int DEFAULT_FACET_SIZE = 10;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("all".equals(req.getParameter((Parameter)StandardParameters.searchgroups))) {
            return new CreateProjectCheck();
        }
        Member member = req.getMember();
        Group group = req.getGroup();
        if (member != null && group != null) {
            return new ViewMemberCheck(member, (PermissionCheck)new ViewGroupCheck(group));
        }
        if (member != null) {
            return new ViewMemberCheck(member);
        }
        if (group != null) {
            return new ViewGroupCheck(group);
        }
        return new AuthenticatedInternalCheck();
    }

    public String getETag(GeneratorRequest req) {
        List<LuceneIndex> indexes = SearchUtils.loadIndexes(req, null);
        if (indexes == null) {
            return null;
        }
        StringBuilder etag = new StringBuilder();
        etag.append("question:").append(req.getParameter((Parameter)StandardParameters.question, ""));
        etag.append(",questionoperator:").append(req.getParameter((Parameter)StandardParameters.questionoperator, "OR"));
        etag.append(",questionfields:").append(req.getParameter((Parameter)StandardParameters.questionfields, ""));
        etag.append(",facets:").append(req.getParameter((Parameter)StandardParameters.facets, ""));
        etag.append(",flexiblefacets:").append(req.getParameter((Parameter)StandardParameters.flexiblefacets, ""));
        etag.append(",facetsize:").append(req.getParameter((Parameter)StandardParameters.facetsize, 10L));
        etag.append(",filters:").append(req.getParameter((Parameter)StandardParameters.filters, ""));
        etag.append(",ranges:").append(req.getParameter((Parameter)StandardParameters.ranges, ""));
        this.addETagValues(req, etag);
        for (Index index : indexes) {
            etag.append(',').append(index.getIndexID()).append(':').append(index.getIndexIO().getLastTimeUsed());
        }
        return MD5.hash((String)etag.toString());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        PageSeederQuery query;
        boolean predicateType;
        Map<Group, Boolean> groups = SearchUtils.loadGroupsToSearch(req, res);
        List<LuceneIndex> indexes = SearchUtils.loadIndexes(req, res, groups);
        if (indexes == null) {
            return;
        }
        if (indexes.isEmpty()) {
            this.finishNoIndexes(req, res);
            return;
        }
        Group group = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups)) ? null : req.getGroup();
        Catalog catalog = SearchUtils.loadCatalog(indexes, group);
        Analyzer analyser = SearchUtils.loadAnalyzer(indexes, group);
        if (catalog == null) {
            catalog = SearchUtils.getGlobalCatalog();
        }
        if (analyser == null) {
            try {
                analyser = IndexAnalyzers.getAnalyzer(null);
            }
            catch (IOException | SAXException ex) {
                LOGGER.error("Failed to create global analyser", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create global analyser: " + ex.getMessage());
            }
        }
        int facetSize = SearchUtils.getIntParameter(req, StandardParameters.facetsize, 10);
        int maxFacetSize = GlobalSettings.getInt((String)MAX_FACET_SIZE_PROPERTY, (int)1000);
        String maxFacetWarning = null;
        if (facetSize > maxFacetSize) {
            maxFacetWarning = StandardParameters.facetsize + " " + facetSize + " is ignored as it is larger than global property maxFacetSize (" + maxFacetSize + ")";
            facetSize = maxFacetSize;
        }
        AllFacets facets = new AllFacets();
        try {
            facets.facets = SearchUtils.computeFacets(req, catalog, StandardParameters.facets);
            facets.ffacets = SearchUtils.computeFacets(req, catalog, StandardParameters.flexiblefacets);
            facets.rangeFacets = SearchUtils.computeRangeFacets(req, catalog, StandardParameters.facets);
            facets.rangeFFacets = SearchUtils.computeRangeFacets(req, catalog, StandardParameters.flexiblefacets);
            facets.intervalFacets = SearchUtils.computeIntervalFacets(req, catalog, StandardParameters.facets);
            facets.intervalFFacets = SearchUtils.computeIntervalFacets(req, catalog, StandardParameters.flexiblefacets);
        }
        catch (SearchException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.ILLEGAL_NUMERIC_FACET, "Illegal numeric facet: " + ex.getIllegalNumericFacet());
            return;
        }
        PageSeederQuery.Builder queryBuilder = new PageSeederQuery.Builder().analyser(IndexAnalyzers.cloneAnalyzerForQuery(analyser)).catalog(catalog);
        String question = req.getParameter((Parameter)StandardParameters.question, "");
        String predicate = this.supportPredicate() ? req.getParameter((Parameter)StandardParameters.predicate, "*") : null;
        boolean bl = predicateType = this.supportPredicate() && "predicate".equals(req.getParameter((Parameter)StandardParameters.type, "predicate"));
        if (predicateType && predicate != null) {
            String defaultField = req.getParameter((Parameter)StandardParameters.defaultfield, "pscontent");
            if (group == null) {
                if (SearchUtils.disallowedGeneralField(defaultField)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Cannot search field " + defaultField + " in global search");
                    return;
                }
                if (predicate.matches(".*?ps(property|inline|block)-[^:]{1,500}:.+")) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Predicate contains invalid search field for global search");
                    return;
                }
            }
            queryBuilder.predicate(predicate).defaultField(defaultField);
        } else {
            String[] rangesParam;
            String[] filtersParam;
            String[] questionfields;
            queryBuilder.question(question).questionDefaultOperatorOR("OR".equalsIgnoreCase(req.getParameter((Parameter)StandardParameters.questionoperator, "AND")));
            for (String qf : questionfields = Strings.split((String)req.getParameter((Parameter)StandardParameters.questionfields, "pstitle,pscontent"), (char)',')) {
                queryBuilder.addSearchField(qf);
                if (group != null || !SearchUtils.disallowedGeneralField(qf)) continue;
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Cannot search field " + qf + " in global search");
                return;
            }
            for (String filter : filtersParam = Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\')) {
                if (filter.isEmpty()) continue;
                if (group == null && SearchUtils.disallowedGeneralField(filter)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Cannot use filter " + filter + " in global search");
                    return;
                }
                SearchUtils.addFilter(filter, catalog, queryBuilder);
            }
            for (String range : rangesParam = Strings.split((String)req.getParameter((Parameter)StandardParameters.ranges, ""), (char)',', (char)'\\')) {
                if (range.isEmpty()) continue;
                if (group == null && SearchUtils.disallowedGeneralField(range)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Cannot use range " + range + " in global search");
                    return;
                }
                queryBuilder.addRange(Ranges.createRange(range, catalog));
            }
        }
        boolean addURLsFilter = false;
        if (group != null && indexes.contains((Object)IndexMaster.getInstance().getURLsIndex())) {
            if (this.addURLsGroupFilter()) {
                for (Group gp : groups.keySet()) {
                    queryBuilder.addStringFilter("psgroupname", gp.getName(), BooleanClause.Occur.SHOULD);
                }
            }
            addURLsFilter = true;
        }
        if (!this.addSort(req, res, catalog, queryBuilder)) {
            return;
        }
        try {
            query = queryBuilder.build();
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_PREDICATE, "Invalid predicate " + predicate + ": " + ex.getMessage());
            return;
        }
        this.finish(req, new ArrayList<LuceneIndex>(indexes), new ArrayList<Group>(groups.keySet()), query, facets, facetSize, maxFacetWarning, catalog, analyser, addURLsFilter, res);
    }

    List<String> printFacets(AllFacets facets, IndexSearcher searcher, PageSeederQuery query, Collection<Group> groups, int facetSize, Catalog catalog, UniversalPrinter out) {
        ArrayList<String> printed = new ArrayList<String>();
        try {
            FlexibleFieldFacet facet;
            for (SearchUtils.Facet facet2 : facets.facets) {
                facet = SearchUtils.createFacet(facet2.field(), catalog);
                if (facet == null) continue;
                facet.compute(searcher, query.toQuery(), facetSize);
                if (facet2.dynamic() && !facet.hasResults()) continue;
                Facets.printFlexibleField(facet, groups, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
            for (SearchUtils.Facet facet3 : facets.ffacets) {
                facet = SearchUtils.createFacet(facet3.field(), catalog);
                if (facet == null) continue;
                facet.compute(searcher, query.getBaseQuery(), query.getFilters(), facetSize);
                if (facet3.dynamic() && !facet.hasResults()) continue;
                Facets.printFlexibleField(facet, groups, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
            for (String string : facets.rangeFacets.keySet()) {
                facet = SearchUtils.createRangeFacet(string, facets.rangeFacets.get(string), catalog);
                facet.compute(searcher, query.toQuery(), facetSize);
                Facets.printFlexibleRange((FlexibleRangeFacet)facet, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
            for (String string : facets.rangeFFacets.keySet()) {
                facet = SearchUtils.createRangeFacet(string, facets.rangeFFacets.get(string), catalog);
                facet.compute(searcher, query.getBaseQuery(), query.getFilters(), facetSize);
                Facets.printFlexibleRange((FlexibleRangeFacet)facet, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
            for (Intervals.Interval interval : facets.intervalFacets) {
                facet = interval.toFacet();
                facet.compute(searcher, query.toQuery(), facetSize);
                Facets.printFlexibleInterval((FlexibleIntervalFacet)facet, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
            for (Intervals.Interval interval : facets.intervalFFacets) {
                facet = interval.toFacet();
                facet.compute(searcher, query.getBaseQuery(), query.getFilters(), facetSize);
                Facets.printFlexibleInterval((FlexibleIntervalFacet)facet, catalog, (OutputPrinter)out);
                printed.add(facet.name());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to compute facets", (Throwable)ex);
        }
        return printed;
    }

    boolean addURLsGroupFilter() {
        return true;
    }

    protected abstract void addETagValues(GeneratorRequest var1, StringBuilder var2);

    protected abstract boolean addSort(GeneratorRequest var1, GeneratorResponse var2, Catalog var3, PageSeederQuery.Builder var4);

    protected abstract boolean supportPredicate();

    protected abstract void finishNoIndexes(GeneratorRequest var1, GeneratorResponse var2) throws IOException;

    protected abstract void finish(GeneratorRequest var1, List<Index> var2, List<Group> var3, PageSeederQuery var4, AllFacets var5, int var6, String var7, Catalog var8, Analyzer var9, boolean var10, GeneratorResponse var11) throws IOException;

    protected static class AllFacets {
        List<SearchUtils.Facet> facets;
        List<SearchUtils.Facet> ffacets;
        Map<String, Collection<FlexibleRangeFacet.Range>> rangeFacets;
        Map<String, Collection<FlexibleRangeFacet.Range>> rangeFFacets;
        Collection<Intervals.Interval> intervalFacets;
        Collection<Intervals.Interval> intervalFFacets;

        protected AllFacets() {
        }

        public boolean isEmpty() {
            return this.facets.isEmpty() && this.ffacets.isEmpty() && this.intervalFacets.isEmpty() && this.intervalFFacets.isEmpty() && this.rangeFacets.isEmpty() && this.rangeFFacets.isEmpty();
        }
    }
}

