/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.search.Terms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(parameters={"index", "field"})
@Output(types={OutputType.XML, OutputType.JSON})
@Beta
public final class ListIndexTerms
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListIndexTerms.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        LuceneIndex index;
        Database db = req.getDatabase();
        IndexMaster master = IndexMaster.getInstance();
        String indexName = req.getParameter((Parameter)StandardParameters.index);
        String field = req.getParameter((Parameter)StandardParameters.field);
        long max = req.getParameter((Parameter)StandardParameters.max, 1000L);
        if (max > 10000L || max <= 0L) {
            max = 10000L;
        }
        UniversalPrinter out = res.getUniversalWriter();
        if ("help".equals(indexName)) {
            index = master.getHelpIndex();
        } else if ("urls".equals(indexName)) {
            index = master.getURLsIndex();
        } else {
            Group group = GroupRule.getGroup((Database)db, (String)indexName);
            if (group == null) {
                res.setError(GeneratorStatus.NOT_FOUND, "Invalid index " + indexName);
                return;
            }
            index = master.getIndex(db, group);
        }
        out.startCollection("terms");
        out.field("field", field);
        IndexReader reader = null;
        try {
            reader = LuceneIndexQueries.grabReader((Index)index);
            int count = 0;
            for (Term term : Terms.terms((IndexReader)reader, (String)field)) {
                out.startObject("term");
                out.field("value", term.text());
                out.field("documents", (long)reader.docFreq(term));
                out.endObject();
                if ((long)count++ <= max) continue;
                break;
            }
        }
        finally {
            out.endCollection();
            LuceneIndexQueries.releaseQuietly((Index)index, (IndexReader)reader);
        }
        out.flush();
    }
}

