/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;

@Requires(database=true, uri=true, group=true)
public final class IndexURI
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        URI uri = req.getURI();
        boolean external = URIs.isExternal((URI)uri);
        if (external) {
            group = null;
        }
        IndexMaster master = IndexMaster.getInstance();
        boolean index = "true".equals(req.getParameter((Parameter)StandardParameters.index, "true"));
        boolean translate = "true".equals(req.getParameter((Parameter)StandardParameters.translate, "false"));
        Publication pub = null;
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        if (!Strings.isEmpty((String)publicationid)) {
            pub = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
        }
        Long releaseID = external ? null : XLinkRule.getValidRelease((Database)db, (URI)uri, (Long)req.getParameter((Parameter)StandardParameters.versionid, -1L), (String)req.getParameter((Parameter)StandardParameters.version), (Publication)pub);
        boolean withGroups = MemberRule.isAdministrator((Database)db, (Member)req.getAuthenticatedMember());
        if (!index) {
            try {
                StringWriter sw = new StringWriter();
                if (!translate) {
                    master.process(group, uri, releaseID, withGroups, sw);
                } else if ("documents".equals(req.getParameter((Parameter)StandardParameters.output))) {
                    List<FlintDocument> docs = master.buildDocuments(db, group, uri, releaseID, withGroups, req.getParameters());
                    XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.Yes);
                    xml.openElement("documents", true);
                    for (FlintDocument doc : docs) {
                        SearchResults.flintDocumentToXML((FlintDocument)doc, (int)0, (XMLWriter)xml);
                    }
                    xml.closeElement();
                    sw.append(xml.toString());
                } else {
                    master.translate(db, group, uri, releaseID, withGroups, req.getParameters(), sw);
                }
                String xml = sw.toString();
                if (xml.startsWith("<?xml ")) {
                    xml = xml.substring(xml.indexOf(62) + 1);
                }
                if (xml.trim().startsWith("<!DOCTYPE ")) {
                    xml = xml.substring(xml.indexOf(62) + 1);
                }
                res.getXMLWriter().writeXML(xml);
            }
            catch (IndexException ex) {
                Logger logger = req.getLogger(IndexURI.class);
                logger.error("Failed to translate uri {}", (Object)uri.getId());
                logger.error("Error is:", (Throwable)ex);
                throw new IOException(ex);
            }
        } else {
            if (external) {
                if (URIs.canBeIndexedAsURL((URI)uri)) {
                    master.indexURL(uri.getId(), uri.isArchived(), null, new PSRequester("Indexing single URL " + URIRule.getURIString((URI)uri)));
                }
            } else if (releaseID != null) {
                master.indexUrgent(db, uri, releaseID, Collections.singleton(group).iterator(), new PSRequester("Indexing version " + releaseID + " of single URI " + uri.getPath()));
            } else {
                master.indexUrgent(db, uri, Collections.singleton(group).iterator(), new PSRequester("Indexing single URI " + uri.getPath()));
            }
            res.getXMLWriter().emptyElement("indexed");
        }
    }
}

