/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupIndexingThread
extends IndexingThreadBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIndexingThread.class);
    private boolean clearFirst = false;
    private Long folderid = null;

    private GroupIndexingThread(String username, String name, Group group) {
        super(username, name, group);
    }

    void setFolderID(Long folderID) {
        this.folderid = folderID;
    }

    void setClearFirst(boolean clear) {
        this.clearFirst = clear;
    }

    public void addTypeToindex(IndexingThreadBase.INDEXTYPE type) {
        this.typesToIndex.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        Database db;
        if (this.typesToIndex.isEmpty()) {
            this.complete("Nothing to Index!");
            return;
        }
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            LOGGER.error("Unable to open database connection", (Throwable)ex);
            return;
        }
        Transaction tr = new Transaction(db);
        IndexBatch batch = null;
        try {
            tr.begin();
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername());
            batch = new IndexBatch(String.valueOf(group.getId()) + "/" + group.getName() + "/Indexing group " + group.getName()).withClearJob();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing objects to index");
            Collection<XLink> comments = this.findComments(db, group);
            if (this.wasCancelled()) {
                return;
            }
            List<IndexingThreadBase.URIToIndex> filefolders = this.findFileFolders(group, db);
            if (filefolders == null || this.wasCancelled()) {
                tr.abort();
                this.complete("Could not compute documents");
                return;
            }
            Map<Long, URI> versions = this.findVersions(db, group, filefolders);
            if (this.wasCancelled()) {
                tr.abort();
                return;
            }
            if (!this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.DOCUMENT)) {
                filefolders = new ArrayList<IndexingThreadBase.URIToIndex>();
            }
            this.total = comments.size() * 2 + versions.size() + filefolders.size();
            batch.increaseTotal(this.total);
            batch.setComputed();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.total + " objects to index");
            if (this.total == 0) {
                tr.commit();
                this.complete("Nothing to index!");
                return;
            }
            if (this.clearFirst) {
                GroupIndexReindexing.startReindexing(group.getId(), batch.getID(), false);
                try {
                    IndexMaster.getInstance().clearIndex(batch, db, group, this.requester, false);
                }
                catch (Exception ex) {
                    IndexMaster.removeIndexFiles(group.getId());
                }
            }
            if (!this.indexComments(comments, group, batch, db) || !this.indexVersions(versions, group, batch, db)) {
                tr.commit();
                return;
            }
            tr.commitAndStart();
            for (IndexingThreadBase.URIToIndex dir : filefolders) {
                if (!this.indexFileFolder(dir, group, member, batch, db, tr)) {
                    tr.commit();
                    return;
                }
                dir = null;
            }
            if (this.folderid == null && this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.COMMENT) && this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.DOCUMENT)) {
                group.setIndexVersion(Settings.CURRENT_INDEX_VERSION);
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            this.fail("Failed to open transaction: " + ex.getMessage());
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to connect to the database", (Throwable)ex);
            this.fail("Failed to connect to the database: " + ex.getMessage());
            tr.abort();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to index", (Throwable)ex);
            this.fail("Failed to index: " + ex.getMessage());
            tr.abort();
        }
        finally {
            if (this.wasCancelled()) {
                tr.abort();
                if (batch != null) {
                    batch.cancel(this.alreadyDone);
                }
            }
            db.close();
            this.complete("Finished adding objects to the indexing queue");
        }
    }

    public static GroupIndexingThread newInstance(String username, String title, Group group) {
        return new GroupIndexingThread(username, title, group);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<IndexingThreadBase.URIToIndex> findFileFolders(Group group, Database db) throws DatabaseException, IOException {
        ArrayList<IndexingThreadBase.URIToIndex> filefolders = new ArrayList<IndexingThreadBase.URIToIndex>();
        if (!this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.DOCUMENT) && !this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.VERSION)) {
            return filefolders;
        }
        if (this.folderid != null) {
            URI folderuri = DatabaseQuery.getURIById((Database)db, (Long)this.folderid);
            if (folderuri == null) {
                this.fail("Folder with uri " + this.folderid + " not found.");
                return null;
            }
            if (!URIRule.isFolder((URI)folderuri)) {
                this.fail("URI with ID " + this.folderid + " is not a folder.");
                return null;
            }
            if (!this.addFolder(filefolders, folderuri, db)) {
                this.fail("Folder with URI ID " + this.folderid + " was ignored due to group properties or because archived.");
                return null;
            }
        } else {
            Collection groupUris = group.getGroupURIsCol();
            for (GroupURI guri : groupUris) {
                this.addGroupURI(filefolders, guri, db);
            }
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + filefolders.size() + " documents/folders to index");
        return filefolders;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("indexing");
        out.startObject("progress");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.endObject();
        out.startCollection("types", OutputPrinter.CollectionOption.JSON_ONLY);
        for (IndexingThreadBase.INDEXTYPE type : this.typesToIndex) {
            out.startObject("type");
            out.field("name", type.toString().toLowerCase());
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }
}

