/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.SearchBase;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.Intervals;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.url.URLsIndex;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.MultipleIndexReader;
import org.pageseeder.flint.lucene.search.StringTermFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetFacets
extends SearchBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFacets.class);

    @Override
    protected void finishNoIndexes(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("facets");
        out.field("indexes", "");
        out.endCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finish(GeneratorRequest req, List<Index> indexes, List<Group> groups, PageSeederQuery query, SearchBase.AllFacets facets, int facetSize, String warning, Catalog catalog, Analyzer analyser, boolean addURLsFilter, GeneratorResponse res) throws IOException {
        IndexSearcher searcher;
        URLsIndex urls = IndexMaster.getInstance().getURLsIndex();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("facets");
        out.field("indexes", indexes.stream().map(Index::getIndexID).collect(Collectors.joining(",")));
        out.startCollection("facets", OutputPrinter.CollectionOption.JSON_ONLY);
        if (warning != null) {
            out.field("warning", warning);
        }
        ArrayList<Index> tosearch = new ArrayList<Index>(indexes);
        PageSeederQuery q = query;
        if (addURLsFilter) {
            if (tosearch.size() == 1 || facetSize > 0) {
                q = this.addURLsFilters(query, groups);
            } else {
                tosearch.remove((Object)urls);
            }
        }
        MultipleIndexReader multi = LuceneIndexQueries.getMultipleIndexReader(tosearch);
        List<String> facetsDone = null;
        try {
            searcher = new IndexSearcher(multi.grab());
            facetsDone = this.printFacets(facets, searcher, q, groups, facetSize, catalog, out);
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to compute facets", (Throwable)ex);
            res.setStatus(GeneratorStatus.SERVER_ERROR);
        }
        finally {
            multi.releaseSilently();
        }
        if (addURLsFilter && indexes.size() > 1 && facetSize == 0) {
            if (facetsDone != null) {
                for (String done : facetsDone) {
                    Intervals.Interval found2;
                    SearchUtils.Facet found = facets.facets.stream().filter(f -> done.equals(f.field())).findFirst().orElse(null);
                    if (found != null) {
                        facets.facets.remove(found);
                    }
                    if ((found = (SearchUtils.Facet)facets.ffacets.stream().filter(f -> done.equals(f.field())).findFirst().orElse(null)) != null) {
                        facets.ffacets.remove(found);
                    }
                    if ((found2 = (Intervals.Interval)facets.intervalFFacets.stream().filter(f -> done.equals(f.toFacet().name())).findFirst().orElse(null)) != null) {
                        facets.intervalFFacets.remove(found2);
                    }
                    if ((found2 = (Intervals.Interval)facets.intervalFacets.stream().filter(f -> done.equals(f.toFacet().name())).findFirst().orElse(null)) != null) {
                        facets.intervalFacets.remove(found2);
                    }
                    facets.rangeFacets.remove(done);
                    facets.rangeFFacets.remove(done);
                }
            }
            searcher = null;
            try {
                searcher = LuceneIndexQueries.grabSearcher((Index)urls);
                this.printFacets(facets, searcher, this.addURLsFilters(query, groups), groups, facetSize, catalog, out);
            }
            finally {
                if (searcher != null) {
                    LuceneIndexQueries.releaseQuietly((Index)urls, (IndexSearcher)searcher);
                }
            }
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private PageSeederQuery addURLsFilters(PageSeederQuery query, List<Group> groups) {
        if (groups.isEmpty()) {
            return query;
        }
        StringTermFilter.Builder filter = new StringTermFilter.Builder().name("psgroupname");
        for (Group gp : groups) {
            filter.addTerm(gp.getName(), BooleanClause.Occur.SHOULD);
        }
        return query.newQuery(Collections.singletonList(filter.build()));
    }

    @Override
    boolean addURLsGroupFilter() {
        return false;
    }

    @Override
    protected void addETagValues(GeneratorRequest req, StringBuilder etag) {
    }

    @Override
    protected boolean addSort(GeneratorRequest req, GeneratorResponse res, Catalog catalog, PageSeederQuery.Builder builder) {
        return true;
    }

    @Override
    protected boolean supportPredicate() {
        return false;
    }
}

