/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptBase;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextContent;
import net.pageseeder.ai.prompt.TextTemplate;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class YamlFormat {
    private YamlFormat() {
    }

    public static String toString(PromptTemplate template) {
        Map<String, Object> data = YamlFormat.init(template);
        data.put("system", template.getSystem().template());
        data.put("user", YamlFormat.contentSpecAsList(template.getUser()));
        Yaml yaml = new Yaml(YamlFormat.defaultDumperOptions());
        return yaml.dump(data);
    }

    public static String toString(Prompt prompt) {
        Map<String, Object> data = YamlFormat.init(prompt);
        data.put("system", prompt.getSystem());
        data.put("user", YamlFormat.contentAsList(prompt.getUser()));
        Yaml yaml = new Yaml(YamlFormat.defaultDumperOptions());
        return yaml.dump(data);
    }

    private static Map<String, Object> init(PromptBase prompt) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("id", prompt.getId());
        data.put("type", prompt.getType());
        data.put("temperature", prompt.getTemperature());
        data.put("max-tokens", prompt.getMaxTokens());
        data.put("owner", prompt.getOwner());
        if (prompt.model != null) {
            data.put("model", prompt.model);
        }
        return data;
    }

    private static List<Map<String, String>> contentSpecAsList(List<ContentSpec> specs) {
        ArrayList<Map<String, String>> user = new ArrayList<Map<String, String>>();
        for (ContentSpec spec : specs) {
            if (spec instanceof TextTemplate) {
                user.add(Collections.singletonMap("text", ((TextTemplate)spec).template()));
                continue;
            }
            user.add(Collections.singletonMap("attachment", ((Attachment)spec).ref()));
        }
        return user;
    }

    private static List<Map<String, String>> contentAsList(List<Content> user) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Content content : user) {
            if (content instanceof TextContent) {
                list.add(Map.of("text", content.getText()));
                continue;
            }
            list.add(Map.of("media", content.mediaType(), "text", content.getText()));
        }
        return list;
    }

    public static PromptTemplate parseTemplate(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            PromptTemplate promptTemplate = YamlFormat.parseTemplate(reader);
            return promptTemplate;
        }
    }

    public static PromptTemplate parseTemplate(Reader reader) throws IOException {
        Yaml parser = new Yaml();
        Map data = (Map)parser.load(reader);
        return YamlFormat.loadTemplate(data);
    }

    public static PromptTemplate parseTemplate(String yaml) {
        Yaml parser = new Yaml();
        Map data = (Map)parser.load(yaml);
        return YamlFormat.loadTemplate(data);
    }

    public static List<ContentSpec> parseUser(String yaml) {
        Yaml parser = new Yaml();
        List specs = (List)parser.load(yaml);
        ArrayList<ContentSpec> out = new ArrayList<ContentSpec>();
        for (Object spec : specs) {
            if (!(spec instanceof Map)) continue;
            Map map = (Map)spec;
            if (map.containsKey("text")) {
                out.add(new TextTemplate(map.get("text").toString()));
                continue;
            }
            if (!map.containsKey("attachment")) continue;
            out.add(new Attachment(map.get("attachment").toString()));
        }
        return out;
    }

    private static PromptTemplate loadTemplate(Map<String, Object> data) {
        Object userData;
        Object maxTokensData;
        Object temperatureData;
        PromptTemplate template = new PromptTemplate();
        if (data.containsKey("id")) {
            template.setId(data.get("id").toString());
        }
        if (data.containsKey("type")) {
            template.setType(data.get("type").toString());
        }
        if (data.containsKey("owner")) {
            template.setOwner(data.get("owner").toString());
        }
        if (data.containsKey("model")) {
            template.setModel(data.get("model").toString());
        }
        if ((temperatureData = data.get("temperature")) instanceof Number) {
            Number t = (Number)temperatureData;
            template.setTemperature(t.doubleValue());
        }
        if ((maxTokensData = data.get("max-tokens")) instanceof Integer) {
            Integer tokens = (Integer)maxTokensData;
            template.setMaxTokens(tokens);
        }
        if (data.containsKey("system")) {
            template.setSystem(data.get("system").toString());
        }
        if (data.containsKey("user") && (userData = data.get("user")) instanceof List) {
            List specs = (List)userData;
            for (Object spec : specs) {
                if (!(spec instanceof Map)) continue;
                Map map = (Map)spec;
                if (map.containsKey("text")) {
                    template.addUser(new TextTemplate(map.get("text").toString()));
                    continue;
                }
                if (!map.containsKey("attachment")) continue;
                template.addUser(new Attachment(map.get("attachment").toString()));
            }
        }
        return template;
    }

    private static DumperOptions defaultDumperOptions() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setIndent(2);
        return options;
    }
}

