/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Options;
import net.pageseeder.ai.prompt.TemplateException;
import net.pageseeder.ai.prompt.TextContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTemplate
implements ContentSpec {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextTemplate.class);
    public static final TextTemplate EMPTY = new TextTemplate("");
    private static final String PLACEHOLDER_REGEX = "\\{\\{\\s*([\\p{L}_][\\p{L}0-9_-]{0,63})\\s*}}";
    private final String template;

    public TextTemplate(String template) {
        this.template = Objects.requireNonNull(template);
    }

    public String template() {
        return this.template;
    }

    public List<String> placeholders() {
        Pattern pattern = Pattern.compile(PLACEHOLDER_REGEX);
        Matcher matcher = pattern.matcher(this.template);
        LinkedHashSet<String> placeholders = new LinkedHashSet<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        return new ArrayList<String>(placeholders);
    }

    public String toPrompt(Map<String, String> parameters, Options options) throws TemplateException {
        Pattern pattern = Pattern.compile(PLACEHOLDER_REGEX);
        Matcher matcher = pattern.matcher(this.template);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = parameters.getOrDefault(key, "");
            if (replacement.isEmpty()) {
                if (options.isStrict()) {
                    throw new TemplateException("Value not found for placeholder: " + key);
                }
                LOGGER.warn("Value not found for placeholder: {}", (Object)key);
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Override
    public List<Content> getContents(Map<String, String> parameters, Options options) throws TemplateException {
        return Collections.singletonList(new TextContent(this.toPrompt(parameters, options)));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextTemplate that = (TextTemplate)o;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public String toString() {
        return this.template;
    }
}

