/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import java.util.Map;

public enum Endpoint {
    MESSAGES("/v1/messages", "POST"),
    COUNT_MESSAGE_TOKENS("/v1/messages/count_tokens", "POST"),
    LIST_MODELS("/v1/models", "GET"),
    GET_MODEL("/v1/models/{model_id}", "GET"),
    CREATE_MESSAGE_BATCH("/v1/messages/batches", "POST"),
    RETRIEVE_MESSAGE_BATCH("/v1/messages/batches/{message_batch_id}", "GET"),
    RETRIEVE_MESSAGE_BATCH_RESULTS("/v1/messages/batches/{message_batch_id}/results", "GET"),
    LIST_MESSAGE_BATCHES("/v1/messages/batches", "GET"),
    CANCEL_MESSAGE_BATCH("/v1/messages/batches/{message_batch_id}/cancel", "POST"),
    DELETE_MESSAGE_BATCH("/v1/messages/batches/{message_batch_id}", "DELETE"),
    CREATE_FILE("/v1/files", "POST"),
    LIST_FILES("/v1/files", "GET"),
    GET_FILE_METADATA("/v1/files/{file_id}", "GET"),
    GET_FILE_CONTENT("/v1/files/{file_id}/content", "GET"),
    DELETE_FILE("/v1/files/{file_id}", "DELETE");

    private final String path;
    private final String method;

    private Endpoint(String path, String method) {
        this.path = path;
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(Map<String, String> parameters) {
        String resolved = this.path;
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            resolved = resolved.replace("{" + p.getKey() + "}", p.getValue());
        }
        return resolved;
    }

    public String getMethod() {
        return this.method;
    }
}

