/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.esc;

import java.io.IOException;
import java.io.Writer;
import org.pageseeder.xmlwriter.esc.XMLEscapeWriter;
import org.pageseeder.xmlwriter.esc.XMLEscapeWriterBase;

public final class XMLEscapeWriterASCII
extends XMLEscapeWriterBase
implements XMLEscapeWriter {
    private static final String ENCODING = "ASCII";

    public XMLEscapeWriterASCII(Writer writer) throws NullPointerException {
        super(writer, ENCODING);
    }

    @Override
    public void writeAttValue(char[] ch, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                this.w.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.w.write("&amp;");
                continue;
            }
            if (c == '\"') {
                this.w.write("&quot;");
                continue;
            }
            if (c == '\'') {
                this.w.write("&#39;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                this.w.write(c);
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                this.w.write("&#x");
                this.w.write(Integer.toHexString(codePoint));
                this.w.write(";");
                continue;
            }
            if (c > '\u009f') {
                this.w.write("&#x");
                this.w.write(Integer.toHexString(c));
                this.w.write(";");
                continue;
            }
            this.w.write(c);
        }
    }

    @Override
    public void writeText(char[] ch, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                this.w.write("&lt;");
                continue;
            }
            if (c == '>') {
                this.w.write("&gt;");
                continue;
            }
            if (c == '&') {
                this.w.write("&amp;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                this.w.write(c);
                continue;
            }
            if (c < ' ') {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            if (c >= '\u007f' && c < '\u00a0') {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                this.w.write("&#x");
                this.w.write(Integer.toHexString(codePoint));
                this.w.write(";");
                continue;
            }
            if (c > '\u009f') {
                this.w.write("&#x");
                this.w.write(Integer.toHexString(c));
                this.w.write(59);
                continue;
            }
            this.w.write(c);
        }
    }

    @Override
    public void writeText(char c) throws IOException {
        if (c == '<') {
            this.w.write("&lt;");
        } else if (c == '>') {
            this.w.write("&gt;");
        } else if (c == '&') {
            this.w.write("&amp;");
        } else if (c == '\n' || c == '\r' || c == '\t') {
            this.w.write(c);
        } else if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
            XMLEscapeWriterASCII.doNothing();
        } else {
            if (c >= '\ud800' && c <= '\udfff') {
                throw new IOException("Unable to handle character #x" + Integer.toHexString(c));
            }
            if (c > '\u00bf') {
                this.w.write("&#x");
                this.w.write(Integer.toHexString(c));
                this.w.write(59);
            } else {
                this.w.write(c);
            }
        }
    }

    private static void doNothing() {
    }
}

