/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.xmlwriter.IllegalCloseElementException;
import org.pageseeder.xmlwriter.UnclosedElementException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterBase;

public final class XMLWriterImpl
extends XMLWriterBase
implements XMLWriter {
    private static final Element ROOT = new Element("", true);
    private final List<Element> _elements = new ArrayList<Element>();

    public XMLWriterImpl(Writer writer) throws NullPointerException {
        super(writer, false);
        this._elements.add(ROOT);
    }

    public XMLWriterImpl(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this._elements.add(ROOT);
    }

    @Override
    void deNude() throws IOException {
        if (this.isNude) {
            this._writer.write(62);
            if (this.peekElement().hasChildren && this.indent) {
                this._writer.write(10);
            }
            this.isNude = false;
        }
    }

    @Override
    public void openElement(String name) throws IOException {
        this.openElement(name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws IOException {
        this.deNude();
        if (this.peekElement().hasChildren) {
            this.indent();
        }
        this._elements.add(new Element(name, hasChildren));
        this._writer.write(60);
        this._writer.write(name);
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void closeElement() throws IOException, IllegalCloseElementException {
        Element parent;
        Element elt = this.popElement();
        if (elt == ROOT) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        if (this.isNude) {
            this._writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this._writer.write(60);
            this._writer.write(47);
            int x = elt.name.indexOf(32);
            if (x < 0) {
                this._writer.write(elt.name);
            } else {
                this._writer.write(elt.name.substring(0, x));
            }
        }
        this._writer.write(62);
        if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
            this._writer.write(10);
        }
    }

    @Override
    public void emptyElement(String element) throws IOException {
        Element parent;
        this.deNude();
        this.indent();
        this._writer.write(60);
        this._writer.write(element);
        this._writer.write(47);
        this._writer.write(62);
        if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
            this._writer.write(10);
        }
    }

    private Element peekElement() {
        return this._elements.get(this._elements.size() - 1);
    }

    private Element popElement() {
        return this._elements.remove(this._elements.size() - 1);
    }

    public void openElement(String uri, String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void emptyElement(String uri, String element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, int value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void close() throws IOException, UnclosedElementException {
        Element open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open.name);
        }
        this._writer.close();
    }

    private static final class Element {
        private final String name;
        private final boolean hasChildren;

        public Element(String name, boolean hasChildren) {
            this.name = name;
            this.hasChildren = hasChildren;
        }
    }
}

