/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.docx.ant.AntLogger;
import org.pageseeder.docx.ant.Parameter;
import org.pageseeder.docx.util.Files;
import org.pageseeder.docx.util.XSLT;
import org.pageseeder.docx.util.ZipUtils;
import org.slf4j.Logger;

public final class ExportTask
extends Task {
    public static String MEDIA_PREFIX = "kwo5nu83zotp2-";
    private File source;
    private File destination;
    private File working;
    private File dotx;
    private File config;
    private File media;
    private List<Parameter> params = new ArrayList<Parameter>();

    public void setSrc(File source) {
        if (!source.exists()) {
            throw new BuildException("the document " + source.getName() + " doesn't exist");
        }
        if (source.isDirectory()) {
            throw new BuildException("the document " + source.getName() + " can't be a directory");
        }
        this.source = source;
    }

    public void setDest(File destination) {
        if (destination.exists() && destination.isDirectory()) {
            throw new BuildException("if document DOCX exists, it must be a file, not " + destination);
        }
        this.destination = destination;
    }

    public void setWordTemplate(File dotx) {
        if (!dotx.exists()) {
            throw new BuildException("the Word template " + dotx.getName() + " doesn't exist");
        }
        if (dotx.isDirectory()) {
            throw new BuildException("the document " + dotx.getName() + " can't be a directory");
        }
        this.dotx = dotx;
    }

    public void setWorking(File working) {
        if (working.exists() && !working.isDirectory()) {
            throw new BuildException("if working folder exists, it must be a directory");
        }
        this.working = working;
    }

    public void setConfig(File config) {
        if (!config.exists() || config.isDirectory()) {
            throw new BuildException("your configuration file must exist and be a file");
        }
        this.config = config;
    }

    public void setMedia(File media) {
        if (!media.exists() || !media.isDirectory()) {
            throw new BuildException("your media folder must exist and be a directory");
        }
        this.media = media;
    }

    public Parameter createParam() {
        Parameter param = new Parameter();
        this.params.add(param);
        return param;
    }

    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("Source presentation must be specified using 'src' attribute");
        }
        if (this.working == null) {
            String tmp = "antdocx-" + System.currentTimeMillis();
            this.working = new File(System.getProperty("java.io.tmpdir"), tmp);
        }
        if (!this.working.exists()) {
            this.working.mkdirs();
        }
        for (Parameter p : this.params) {
            if (p.getName() == null) {
                throw new BuildException("parameters must have a name");
            }
            if (!p.getName().startsWith("_")) continue;
            throw new BuildException("parameter names must not start with an underscore");
        }
        String name = this.source.getName();
        if (name.endsWith(".psml")) {
            name = name.substring(0, name.length() - 5);
        }
        if (this.destination == null) {
            this.destination = new File(this.source.getParentFile(), name + ".docx");
            this.log("Destination set to " + this.destination.getName());
        }
        if (this.config == null) {
            this.config = null;
            this.log("Using default wpml configuration for export");
        }
        if (this.dotx == null) {
            this.log("No DOTX specified, using default word temlate ");
            this.dotx = ExportTask.getBuiltinWordTemplate(this.working);
        }
        this.log("Extracting template: " + this.dotx.getName());
        File dotx = new File(this.working, "dotx");
        dotx.mkdirs();
        ZipUtils.unzip((File)this.dotx, (File)dotx);
        this.log("Checking template");
        File contentTypes = new File(dotx, "[Content_Types].xml");
        File relationships = new File(dotx, "_rels/.rels");
        if (!contentTypes.exists()) {
            throw new BuildException("Not a valid DOTX: unable to find [Content_Types].xml");
        }
        if (!relationships.exists()) {
            throw new BuildException("Not a valid DOTX: unable to find _rels/.rels");
        }
        File prepacked = new File(this.working, "prepacked");
        prepacked.mkdirs();
        ZipUtils.unzip((File)this.dotx, (File)prepacked);
        File document = new File(prepacked, "word/document.xml");
        Files.ensureDirectoryExists((File)document.getParentFile());
        File mediaFolder = new File(prepacked, "word/media");
        String mediaPrefix = "";
        if (this.media != null) {
            this.log("Copying media files");
            if (!mediaFolder.exists()) {
                mediaFolder.mkdirs();
            }
            mediaPrefix = MEDIA_PREFIX;
            Files.renameFiles((File)mediaFolder, (String)mediaPrefix);
            try {
                Files.copyDirectory((File)this.media, (File)mediaFolder);
            }
            catch (IOException e) {
                this.log("Failed to copy media files: " + e.getMessage());
            }
        }
        this.log("Unnesting");
        Templates unnest = XSLT.getTemplatesFromResource((String)"org/pageseeder/docx/xslt/export-unnest.xsl");
        File sourceDocument = this.source;
        File newSourceDocument = new File(this.working, "unnested/document-unnested.psml");
        newSourceDocument.getParentFile().mkdir();
        Map noParameters = Collections.emptyMap();
        Logger logger = AntLogger.newInstance(this);
        XSLT.transform((File)sourceDocument, (File)newSourceDocument, (Templates)unnest, noParameters, (Logger)logger);
        this.log("Processing with XSLT");
        Templates templates = XSLT.getTemplatesFromResource((String)"org/pageseeder/docx/xslt/export.xsl");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_outputfolder", prepacked.toURI().toString());
        parameters.put("_dotxfolder", dotx.toURI().toString());
        parameters.put("_docxfilename", this.destination.getName());
        parameters.put("_mediaprefix", mediaPrefix);
        if (this.config != null) {
            parameters.put("_configfileurl", this.config.toURI().toString());
        }
        for (Parameter p : this.params) {
            parameters.put(p.getName(), p.getValue());
        }
        XSLT.transform((File)newSourceDocument, (File)document, (Templates)templates, parameters, (Logger)logger);
        if (parameters.containsKey("expanded") && ((String)parameters.get("expanded")).equals("true")) {
            this.log("Moving");
            prepacked.renameTo(this.destination);
        } else if (parameters.containsKey("generate-processed-psml") && ((String)parameters.get("generate-processed-psml")).equals("true")) {
            this.log("Copying processed PSML");
            File newDestinationDocument = new File(this.destination.getParentFile() + "/document.xml");
            try {
                Files.copy((File)document, (File)newDestinationDocument);
            }
            catch (IOException e) {
                this.log("Failed to copy processed PSML: " + e.getMessage());
            }
            this.destination.getParentFile().mkdirs();
            ZipUtils.zip((File)prepacked, (File)this.destination);
        } else {
            this.log("Zipping");
            this.destination.getParentFile().mkdirs();
            ZipUtils.zip((File)prepacked, (File)this.destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getBuiltinWordTemplate(File working) {
        File tmp = new File(working, "default.dotx");
        try {
            ClassLoader loader = ExportTask.class.getClassLoader();
            try (InputStream in = loader.getResourceAsStream("org/pageseeder/docx/resource/default.dotx");
                 FileOutputStream out = new FileOutputStream(tmp);){
                int n;
                byte[] buffer = new byte[1024];
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException("Unable to extract default word template", (Throwable)ex);
        }
        return tmp;
    }
}

