/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.Scope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Requires(member=true, parameters={"client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class UpdateClient
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.member) != null || req.getParameter((Parameter)StandardParameters.identifier) != null) {
            return new ManageOAuthCheck(req.getHttpServletRequest());
        }
        return new ViewOAuthMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        boolean confidential;
        GrantType grant;
        Client c;
        String clientId = req.getParameter((Parameter)StandardParameters.client);
        Database db = req.getDatabase();
        Client client = OAuthQuery.getClient((Database)db, (String)clientId);
        if (client == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid client ID");
            return;
        }
        if (!(MemberRule.isAdministrator((Database)db, (Member)req.getAuthenticatedMember()) || client.getMember() != null && req.getMember().getId().equals(client.getMember().getId()))) {
            res.setError(GeneratorStatus.FORBIDDEN, "The client is not owned by this member.");
            return;
        }
        String name = req.getParameter((Parameter)StandardParameters.name, client.getName());
        String identifier = req.getParameter((Parameter)StandardParameters.identifier);
        String redirectURI = req.getParameter((Parameter)StandardParameters.redirect_uri);
        String clientURI = req.getParameter((Parameter)StandardParameters.client_uri);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String grantType = req.getParameter((Parameter)StandardParameters.grant_type, client.getGrantType().toString());
        String scope = req.getParameter((Parameter)StandardParameters.scope);
        String member = req.getParameter((Parameter)StandardParameters.member);
        String app = req.getParameter((Parameter)StandardParameters.app);
        String webhookSecret = req.getParameter((Parameter)StandardParameters.webhook_secret);
        if (!(Strings.isEmpty((String)webhookSecret) || webhookSecret.length() >= 24 && webhookSecret.length() <= 64)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The webhook-secret must be at least 24 characters and not more than 64");
            return;
        }
        if (webhookSecret == null) {
            webhookSecret = client.getWebhookSecret();
        }
        if (webhookSecret != null && webhookSecret.isEmpty()) {
            webhookSecret = null;
        }
        if (!Strings.isEmpty((String)name) && (c = OAuthQuery.getClientByName((Database)db, (String)name)) != null && !c.getId().equals(client.getId())) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Name already in use");
            return;
        }
        if (!Strings.isEmpty((String)member)) {
            List clients;
            Member mem = MemberRule.getMember((Database)req.getDatabase(), (String)member);
            if (mem == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Invalid member");
                return;
            }
            if (!(client.getMember() != null && mem.getId().equals(client.getMember().getId()) || (clients = OAuthQuery.listClientsByMemberID((Database)db, (Long)mem.getId())).size() < 10)) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Maximum number of clients for this member has been reached");
                return;
            }
            client.setMember(mem);
        }
        try {
            grant = GrantType.valueOf((String)grantType);
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid grant type");
            return;
        }
        long accessTokenMaxAge = req.getParameter((Parameter)StandardParameters.access_token_max_age, client.getAccessTokenMaxAge(TimeUnit.SECONDS));
        long refreshTokenMaxAge = 0L;
        if (grant == GrantType.authorization_code || grant == GrantType.password) {
            refreshTokenMaxAge = req.getParameter((Parameter)StandardParameters.refresh_token_max_age, client.getRefreshTokenMaxAge(TimeUnit.SECONDS));
        }
        if (clientURI != null && clientURI.length() > 0) {
            try {
                new URI(clientURI);
            }
            catch (URISyntaxException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Malformed client URI");
                return;
            }
        }
        if (redirectURI != null && redirectURI.length() > 0) {
            try {
                new URI(redirectURI);
            }
            catch (URISyntaxException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Malformed redirect URI");
                return;
            }
        }
        boolean bl = confidential = redirectURI != null && redirectURI.startsWith("https://");
        if (clientURI != null && !Objects.equals(client.getClientURI(), clientURI)) {
            CORS.removeOrigin((String)client.getClientURI());
            CORS.addOrigin((String)clientURI);
        }
        if (!Strings.isEmpty((String)identifier) && !identifier.equalsIgnoreCase(client.getIdentifier())) {
            if (OAuthQuery.getClientByIdentifier((Database)db, (String)identifier) != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Client already exists");
                return;
            }
            if (!Client.isValidIdentifier((String)identifier)) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Identifier must be a 16 digit hexadecimal number");
                return;
            }
            client.setIdentifier(identifier);
        }
        client.setName(name);
        if (redirectURI != null) {
            client.setRedirectURI(redirectURI);
        }
        if (clientURI != null) {
            client.setClientURI(clientURI);
        }
        client.setAccessTokenMaxAge(accessTokenMaxAge, TimeUnit.SECONDS);
        client.setRefreshTokenMaxAge(refreshTokenMaxAge, TimeUnit.SECONDS);
        client.setConfidential(confidential);
        if (description != null) {
            client.setDescription(description);
        }
        client.setGrant(grant);
        if (scope != null) {
            Set scopes = Scope.fromDelimitedString((String)scope);
            if (scopes.contains(Scope.UNKNOWN)) {
                res.setError(GeneratorStatus.BAD_REQUEST, "One of the values in scope is not supported");
                return;
            }
            if (scope.length() > 255) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Scope must be less than 256 characters");
                return;
            }
            client.setScope(scope);
        }
        if (app != null) {
            client.setAppName(app);
        }
        client.setWebhookSecret(webhookSecret);
        client.setDateModified(new Date());
        String secret = req.getParameter((Parameter)StandardParameters.client_secret, null);
        if (secret != null && secret.length() > 0) {
            client.setActualSecret(secret);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("client-modification");
        out.writeClient(client);
        out.endObject();
        out.flush();
    }
}

