/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;

@Requires(parameters={"tokenid"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class RevokePersistentToken
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Long tokenId = req.getParameter((Parameter)StandardParameters.tokenid, -1L);
        PersistentToken t = OAuthQuery.getPersistentToken((Database)req.getDatabase(), (Long)tokenId);
        if (t == null) {
            return new NoCheck();
        }
        return new ViewOAuthMemberCheck(t.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long tokenId = req.getParameter((Parameter)StandardParameters.tokenid, -1L);
        Database db = req.getDatabase();
        PersistentToken t = OAuthQuery.getPersistentToken((Database)db, (Long)tokenId);
        if (t != null) {
            t.delete(db);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("persistent-token-revocation", OutputPrinter.ObjectOption.XML_EMPTY);
            out.endObject();
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "No matching token");
        }
    }
}

