/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;

@Requires(parameters={"client-identifier", "member-id"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class IssueRefreshToken
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (GlobalSettings.getBoolean((String)"manualTokenCreation", (boolean)false)) {
            return new ManageOAuthCheck(req.getHttpServletRequest());
        }
        return new ForbiddenCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String clientId = req.getParameter((Parameter)StandardParameters.client_identifier);
        long memberId = req.getParameter((Parameter)StandardParameters.member_id, -1L);
        String scope = req.getParameter((Parameter)StandardParameters.scope, "");
        Database db = req.getDatabase();
        Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
        if (client == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid client ID");
            return;
        }
        Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
        if (member == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid member ID");
            return;
        }
        PersistentToken t = PersistentToken.issueRefreshToken((Database)db, (Client)client, (Member)member, (String)scope);
        res.setStatus(GeneratorStatus.CREATED);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("refresh-token-issue");
        out.writePersistenToken(t);
        out.endObject();
        out.flush();
    }
}

