/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;

@Requires(parameters={"token", "token-type"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class GetTokenInfo
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String token = req.getParameter((Parameter)StandardParameters.token);
        String type = req.getParameter((Parameter)StandardParameters.token_type);
        if ("access_token".equals(type)) {
            AccessTokenManager manager = AccessTokenManager.singleton();
            AccessToken t = manager.get(token);
            if (t != null) {
                UniversalPrinter out = res.getUniversalWriter();
                out.write((UniversallyPrintable)t);
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, "No matching token");
            }
        } else if ("refresh_token".equals(type)) {
            Database db = req.getDatabase();
            PersistentToken t = OAuthQuery.getPersistentToken((Database)db, (String)token);
            if (t != null) {
                UniversalPrinter out = res.getUniversalWriter();
                out.writePersistenToken(t);
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, "No matching token");
            }
        } else {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid token type");
        }
    }
}

