/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.common.util.BinaryFormat;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.Scope;
import com.pageseeder.oauth.util.MemberErrorID;
import com.pageseeder.oauth.util.Members;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Requires(member=true, parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateClient
implements Generator,
SingleCheck {
    public static final int MAX_MEMBER_CLIENTS = 10;
    public static final int MAX_SERVER_CLIENTS = 1000;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.member) != null || req.getParameter((Parameter)StandardParameters.identifier) != null) {
            return new ManageOAuthCheck(req.getHttpServletRequest());
        }
        return new ViewOAuthMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Set scopes;
        GrantType grant;
        List clients;
        String name = req.getParameter((Parameter)StandardParameters.name);
        String identifier = req.getParameter((Parameter)StandardParameters.identifier);
        Database db = req.getDatabase();
        Member member = Members.getMember(req);
        if (member == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        if (!MemberRule.isAdministrator((Database)db, (Member)member) && (clients = OAuthQuery.listClientsByMemberID((Database)db, (Long)member.getId())).size() >= 10) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Maximum number of clients for this member has been reached.");
            return;
        }
        if (OAuthQuery.getClientCount((Database)db) >= 1000) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Maximum number of clients for server has been reached.");
            return;
        }
        Client client = OAuthQuery.getClientByName((Database)db, (String)name);
        if (client != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Client already exists");
            return;
        }
        client = Client.create((Database)db);
        client.setName(name);
        if (!Strings.isEmpty((String)identifier)) {
            if (OAuthQuery.getClientByIdentifier((Database)db, (String)identifier) != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Client already exists");
                return;
            }
            if (!Client.isValidIdentifier((String)identifier)) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Identifier must be a 16 digit hexadecimal number");
                return;
            }
            client.setIdentifier(identifier);
        }
        String redirectURI = req.getParameter((Parameter)StandardParameters.redirect_uri);
        URI uri = null;
        if (redirectURI != null && redirectURI.length() > 0) {
            try {
                uri = new URI(redirectURI);
            }
            catch (URISyntaxException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Malformed redirect uri");
                return;
            }
            client.setRedirectURI(redirectURI);
        }
        client.setClientURI(req.getParameter((Parameter)StandardParameters.client_uri, (String)(uri != null ? uri.getScheme() + "://" + uri.getAuthority() : "")));
        String grantType = req.getParameter((Parameter)StandardParameters.grant_type, "authorization_code");
        try {
            grant = GrantType.valueOf((String)grantType);
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid grant type");
            return;
        }
        client.setGrant(grant);
        String secret = req.getParameter((Parameter)StandardParameters.client_secret, Passwords.randomBytes((int)16, (BinaryFormat)BinaryFormat.BASE_64_URL));
        if (secret != null && secret.length() > 0) {
            client.setActualSecret(secret);
        }
        long tokenMaxAge = req.getParameter((Parameter)StandardParameters.access_token_max_age, Client.DEFAULT_ACCESS_TOKEN_MAX_AGE_SECONDS);
        long refreshPeriod = 0L;
        if (grant == GrantType.authorization_code || grant == GrantType.password) {
            refreshPeriod = req.getParameter((Parameter)StandardParameters.refresh_token_max_age, Client.DEFAULT_REFRESH_TOKEN_MAX_AGE_SECONDS);
        }
        client.setAccessTokenMaxAge(tokenMaxAge, TimeUnit.SECONDS);
        client.setRefreshTokenMaxAge(refreshPeriod, TimeUnit.SECONDS);
        String scope = req.getParameter((Parameter)StandardParameters.scope);
        if (scope == null || scope.trim().isEmpty()) {
            scope = "all";
        }
        if ((scopes = Scope.fromDelimitedString((String)scope)).contains(Scope.UNKNOWN)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "One of the values in scope is not supported");
            return;
        }
        if (scope != null && scope.length() > 255) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Scope must be less than 256 characters");
            return;
        }
        String webhookSecret = req.getParameter((Parameter)StandardParameters.webhook_secret, null);
        if (webhookSecret != null && (webhookSecret.length() < 24 || webhookSecret.length() > 64)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The webhook-secret must be at least 24 characters and not more than 64");
            return;
        }
        client.setScope(scope);
        client.setRequiresConsent(false);
        client.setConfidential(redirectURI != null && redirectURI.startsWith("https://"));
        client.setDescription(req.getParameter((Parameter)StandardParameters.description));
        client.setAppName(req.getParameter((Parameter)StandardParameters.app));
        client.setWebhookSecret(webhookSecret);
        client.setMember(member);
        client.insert(db);
        CORS.addOrigin((String)client.getClientURI());
        res.setStatus(GeneratorStatus.CREATED);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("client-registration");
        out.field("secret", secret);
        out.writeClient(client);
        out.endObject();
        out.flush();
    }
}

