/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public final class BitCollector
extends SimpleCollector {
    private int _docbase;
    private final BitSet _bits;

    public BitCollector(int size) {
        this._bits = new BitSet(size);
    }

    public BitCollector(BitSet bits) {
        this._bits = bits;
    }

    public void collect(int doc) {
        this._bits.set(doc + this._docbase);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        this._docbase = context.docBase;
    }

    public BitSet getBits() {
        return this._bits;
    }

    public int getCount() {
        return this._bits.cardinality();
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

